#import "NSStringAdditions.h"
#import "CMRuntime.h"
#import "CMObjCTypeConverter.h"
#import "CMInteger.h"


@implementation NSString (CMAdditions)

- (SEL)selectorValue { return NSSelectorFromString(self); }
- (Class)classValue { return NSClassFromString(self); }

- (id)evaluate
{
  return [[CMRuntime defaultRuntime] loadWithString:self];
}

+ (id)stringWithFormat:(NSString *)format objects:(NSArray *)objects
{
  return [[[self alloc] initWithFormat:format objects:objects] autorelease];

}

+ (id)localizedStringWithFormat:(NSString *)format objects:(NSArray *)objects
{
  NSDictionary *locale = [[NSBundle mainBundle] localizedInfoDictionary];
  return [[[self alloc] initWithFormat:format
                        locale:locale
                        objects:objects] autorelease];
}

- (id)initWithFormat:(NSString *)format objects:(NSArray *)objects
{
  return [self initWithFormat:format locale:nil objects:objects];
}


#define BASE_FLAG  1
#define PLUS_FLAG  2
#define SPACE_FLAG 4
#define LEFT_FLAG  8
#define RIGHT_FLAG 16

- (id)initWithFormat:(NSString *)format
              locale:(NSDictionary *)aDictionary
             objects:(NSArray *)objects;
{
  NSString *matched, *localized, *template;
  NSMutableString *buffer;
  NSScanner *scanner;
  id e, obj;
  BOOL isSpecifier = NO, isPrecision = NO;
  unichar *unichars;
  int flag = 0, precision = 6, width = 0;

  [self autorelease];
  buffer = [NSMutableString stringWithCapacity:1];
  e = [objects objectEnumerator];
  scanner = [NSScanner scannerWithString:format];
  [scanner setCharactersToBeSkipped:nil];
  while (![scanner isAtEnd]) {
    if (isSpecifier) {
      matched = nil;
      [scanner scanString:@"%" intoString:&matched];
      if (matched) {
        [buffer appendString:@"%"];
        isSpecifier = NO;
        continue;
      }


      //
      // specifier
      //

      matched = nil;
      [scanner scanString:@"@" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        localized = [aDictionary objectForKey:[obj description]];
        if (!localized)
          localized = [obj description];
        template = [self _formatStringWithSpecifier:@"@"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj description]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"d" intoString:&matched];
      if (!matched)
        [scanner scanString:@"D" intoString:&matched];
      if (!matched)
        [scanner scanString:@"i" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"d"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj longValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"u" intoString:&matched];
      if (!matched)
        [scanner scanString:@"U" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"u"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"hi" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"hi"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj shortValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"hu" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"hu"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedShortValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"qi" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"qi"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj longLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"qu" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"qu"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"x" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"x"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"X" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"X"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"qx" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"qx"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"qX" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"qX"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"o" intoString:&matched];
      if (!matched)
        [scanner scanString:@"O" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"o"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj unsignedLongValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"f" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"f"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj doubleValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"e" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"e"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj doubleValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"E" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"E"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj doubleValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"g" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"g"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj doubleValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"G" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"G"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj doubleValue]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"c" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"c"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj cString][0]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"C" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"C"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj characterAtIndex:1]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"s" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"s"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, [obj cString]];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"S" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        unichars = malloc(sizeof(unichar) * ([(NSString *)obj length]+1));
        unichars[[(NSString *)obj length]+1] = nil;
        [obj getCharacters:unichars];
        template = [self _formatStringWithSpecifier:@"S"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, unichars];
        isSpecifier = NO;
        continue;
      }

      matched = nil;
      [scanner scanString:@"p" intoString:&matched];
      if (matched) {
        obj = [e nextObject];
        template = [self _formatStringWithSpecifier:@"p"
                         flag:flag width:width precision:precision];
        [buffer appendFormat:template, (void *)obj];
        isSpecifier = NO;
        continue;
      }


      //
      // flag
      //

      matched = nil;
      [scanner scanString:@"#" intoString:&matched];
      if (matched) {
        flag = flag | BASE_FLAG;
        continue;
      }

      matched = nil;
      [scanner scanString:@"+" intoString:&matched];
      if (matched) {
        flag = flag | PLUS_FLAG;
        continue;
      }

      matched = nil;
      [scanner scanString:@" " intoString:&matched];
      if (matched) {
        flag = flag | SPACE_FLAG;
        continue;
      }

      matched = nil;
      [scanner scanString:@"-" intoString:&matched];
      if (matched) {
        flag = flag | LEFT_FLAG;
        continue;
      }

      matched = nil;
      [scanner scanString:@"0" intoString:&matched];
      if (matched) {
        flag = flag | RIGHT_FLAG;
        continue;
      }


      //
      // width and precision
      //

      matched = nil;
      [scanner scanCharactersFromSet:[NSCharacterSet decimalDigitCharacterSet]
               intoString:&matched];
      if (matched) {
        if (isPrecision)
          precision = [matched intValue];
        else
          width = [matched intValue];
        continue;
      }

      matched = nil;
      [scanner scanString:@"*" intoString:&matched];
      if (matched) {
        if (isPrecision)
          precision = [[e nextObject] intValue];
        else
          width = [[e nextObject] intValue];
        continue;
      }


      //
      // precision
      //

      matched = nil;
      [scanner scanString:@"." intoString:&matched];
      if (matched) {
        isPrecision = YES;
        precision = -1;
        continue;
      }


      //
      // other
      //

      isSpecifier = NO;

    } else {
      matched = nil;
      [scanner scanUpToString:@"%" intoString:&matched];
      if (matched) [buffer appendString:matched];
      matched = nil;
      [scanner scanString:@"%" intoString:&matched];
      if (matched) isSpecifier = YES;
    }
  }

  return [[[self class] alloc] initWithString:buffer];
}

- (NSString *)_formatStringWithSpecifier:(NSString *)aSpecifier
                                    flag:(int)flag
                                   width:(int)width
                               precision:(int)precision
{
  NSMutableString *format;

  format = [NSMutableString stringWithString:@"%"];
  if (flag & BASE_FLAG)  [format appendString:@"#"];
  if (flag & PLUS_FLAG)  [format appendString:@"+"];
  if (flag & SPACE_FLAG) [format appendString:@" "];
  if (flag & LEFT_FLAG)  [format appendString:@"-"];
  if (flag & RIGHT_FLAG) [format appendString:@"0"];
  if (width != 0)        [format appendFormat:@"%d", width];
  if (precision != 0) {
    [format appendString:@"."];
    if (precision != -1)
      [format appendFormat:@"%d", precision];
  }

  [format appendString:aSpecifier];

  return format;
}

- (NSString *)format:(NSArray *)objects
{
  return [NSString stringWithFormat:self objects:objects];
}

- (void)appendFormat:(NSString *)format objects:(NSArray *)objects
{
  [(NSMutableString *)self appendString:[NSString stringWithFormat:format
                                                  objects:objects]];
}

- (NSString *)stringByAppendingFormat:(NSString *)format objects:(NSArray *)objects
{
  NSMutableString *str = [NSMutableString stringWithString:self];
  [str appendFormat:format objects:objects];
  return [NSString stringWithString:str];
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_INT(objCType) || IS_ENCODE_UINT(objCType)) {
    static int val;
    val = [self intValue];
    return &val;

  } else if (IS_ENCODE_LONG(objCType)) {
    static long val;
    val = [[CMInteger integerWithString:self] longValue];
    return &val;

  } else if (IS_ENCODE_ULONG(objCType)) {
    static unsigned long val;
    val = [[CMInteger integerWithString:self] unsignedLongValue];
    return &val;

  } else if (IS_ENCODE_LONGLONG(objCType)) {
    static long long val;
    val = [[CMInteger integerWithString:self] longLongValue];
    return &val;

  } else if (IS_ENCODE_ULONGLONG(objCType)) {
    static unsigned long long val;
    val = [[CMInteger integerWithString:self] unsignedLongLongValue];
    return &val;

  } else if (IS_ENCODE_FLOAT(objCType) || IS_ENCODE_DOUBLE(objCType)) {
    static double val;
    val = [self doubleValue];
    return &val;

  } else if (IS_ENCODE_CLASS(objCType)) {
    static Class class;
    class = NSClassFromString(self);
    return &class;

  } else if (IS_ENCODE_SEL(objCType)) {
    static SEL sel;
    sel = NSSelectorFromString(self);
    return &sel;

  } else if (IS_ENCODE_CHARP(objCType) || IS_ENCODE_VOIDP(objCType)) {
    static const char *val;
    val = [self cString];
    return &val;
  }

  return [super objCValueWithType:objCType];
}

@end
