#import "NSObjectAdditions.h"
#import "CMClass.h"
#import "CMMethod.h"
#import "CMBlock.h"
#import "CMContext.h"

@implementation NSObject (CMAdditions)

- (void)log
{
  NSLog([self description]);
}

@end


@implementation NSObject (CMEnumerating)

- (BOOL)isEmpty
{
  return [(id)self count] == 0;
}

- (BOOL)notEmpty
{
  return [(id)self count] != 0;
}

- (SEL)enumerationSelector
{
  return @selector(objectEnumerator);
}

- (NSEnumerator *)doEnumerator
{
  return [self performSelector:[self enumerationSelector]];
}

- (void)do:(CMBlock *)aBlock
{
  id obj, e = [self doEnumerator];
  while (obj = [e nextObject]) {
    [aBlock value:obj];
    if (![[CMContext sender] continuesVisitation])
      break;
  }
}

- (id)do:(CMBlock *)aBlock withDefaultValue:(id)anObject
{
  id value, obj, e = [self doEnumerator];
  value = anObject;
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    value = [aBlock value:value value:obj];
  }
  return value;
}

- (void)do:(CMBlock *)aBlock withoutObject:(NSArray *)anObject
{
  id obj, e = [self doEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    if (![obj isEqual:anObject]) {
      [aBlock value:obj];
    }
  }
}

- (void)do:(CMBlock *)aBlock withoutObjects:(NSArray *)objects
{
  id obj, e = [self doEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    if (![objects containsObject:obj])
      [aBlock value:obj];
  }
}

- (id)detect:(CMBlock *)aBlock
{
  return [self detect:aBlock ifNone:nil];
}

- (id)detect:(CMBlock *)aBlock ifNone:(CMBlock *)exceptionBlock
{
  id obj, e = [self doEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    if ([[aBlock value:obj] boolValue])
      return obj;
  }
  return [exceptionBlock value];
}

- (NSArray *)reject:(CMBlock *)aBlock
{
  NSMutableArray *array = [NSMutableArray arrayWithCapacity:1];
  id obj, e = [self doEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    if (![[aBlock value:obj] boolValue])
      [array addObject:obj];
  }
  return array;

}

- (NSArray *)select:(CMBlock *)aBlock
{
  NSMutableArray *array = [NSMutableArray arrayWithCapacity:1];
  id obj, e = [self doEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    if ([[aBlock value:obj] boolValue])
      [array addObject:obj];
  }
  return array;
}

- (NSArray *)collect:(CMBlock *)aBlock
{
  NSMutableArray *array = [NSMutableArray arrayWithCapacity:1];
  id obj, e = [self doEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    [array addObject:[aBlock value:obj]];
  }
  return array;
}

@end


@implementation NSObject (CMComparing)

- (BOOL)isEqualTo:(id)anObject
{
  return [self isEqual:anObject];
}

- (BOOL)isNotEqualTo:(id)anObject
{
  return ![self isEqual:anObject];
}

- (BOOL)isGreaterThan:(id)anObject
{
  return [self compare:anObject] == NSOrderedDescending;
}

- (BOOL)isGreaterThanOrEqualTo:(id)anObject
{
  BOOL result = [self compare:anObject];
  return (result == NSOrderedSame) || (result == NSOrderedDescending);
}

- (BOOL)isLessThan:(id)anObject
{
  return [self compare:anObject] == NSOrderedAscending;
}

- (BOOL)isLessThanOrEqualTo:(id)anObject
{
  BOOL result = [self compare:anObject];
  return (result == NSOrderedSame) || (result == NSOrderedAscending);
}

- (NSComparisonResult)compare:(id)anObject
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

@end

