#import <Cocoa/Cocoa.h>

@class CMBlock;

@interface NSObject (CMAdditions)
- (void)log;
@end

@interface NSObject (CMEnumerating)
- (BOOL)isEmpty;
- (BOOL)notEmpty;
- (SEL)enumerationSelector;
- (void)do:(CMBlock *)aBlock;
- (id)do:(CMBlock *)aBlock withDefaultValue:(id)anObject;
- (void)do:(CMBlock *)aBlock withoutObject:(NSArray *)anObject;
- (void)do:(CMBlock *)aBlock withoutObjects:(NSArray *)objects;
- (id)detect:(CMBlock *)aBlock;
- (id)detect:(CMBlock *)aBlock ifNone:(CMBlock *)exceptionBlock;
- (NSArray *)collect:(CMBlock *)aBlock;
- (NSArray *)reject:(CMBlock *)aBlock;
- (NSArray *)select:(CMBlock *)aBlock;
@end

@interface NSObject (CMComparing)
- (BOOL)isEqualTo:(id)anObject;
- (BOOL)isNotEqualTo:(id)anObject;
- (BOOL)isGreaterThan:(id)anObject;
- (BOOL)isGreaterThanOrEqualTo:(id)anObject;
- (BOOL)isLessThan:(id)anObject;
- (BOOL)isLessThanOrEqualTo:(id)anObject;
- (NSComparisonResult)compare:(id)anObject;
@end

