#import "NSFileHandleAdditions.h"
#import "CMApplication.h"

@implementation NSFileHandle (CMAdditions)

- (NSString *)read
{
  NSData *data = [self readDataToEndOfFile];
  return [[[NSString alloc] initWithData:data
                            encoding:[CMApplication defaultEncoding]]
           autorelease];
}

- (void)write:(id)anObject
{
  NSData *data;
  data = [[anObject description] dataUsingEncoding:[CMApplication defaultEncoding]];
  [self writeData:data];
}

- (void)writeLine:(id)anObject
{
  [self write:anObject];
  [self writeNewLine];
}

- (void)writeNewLine
{
  [self writeData:[NSData dataWithBytes:"\n" length:1]];
}

@end
