#import "NSExceptionAdditions.h"
#import "CMBlock.h"
#import "CMContext.h"

static id resumableDictionary = nil;

@implementation NSException (CMAdditions)

+ (NSMutableDictionary *)resumableDictionary
{
  if (!resumableDictionary)
    resumableDictionary = [[NSMutableDictionary alloc] initWithCapacity:1];
  return resumableDictionary;
}

+ (BOOL)isResumableForName:(NSString *)name
{
  return [[[self resumableDictionary] objectForKey:name] boolValue];
}

+ (void)setIsResumable:(BOOL)flag forName:(NSString *)name
{
  [[self resumableDictionary] setObject:[NSNumber numberWithBool:flag]
                              forKey:name];
}

- (BOOL)isResumable
{
  if ([self name])
    return [NSException isResumableForName:[self name]];
  return NO;
}

- (id)return
{
  return [self return:nil];
}

- (id)return:(id)anObject
{
  [[CMContext sender] setContinuesVisitation:NO];
  return anObject;
}

- (void)pass
{
  [[CMContext sender] setContinuesVisitation:NO];
  [[CMContext sender] setPassesException:YES];
}

- (void)retry
{
  [[CMContext sender] setContinuesVisitation:NO];
  [[CMContext sender] setDoesRetry:YES];
  [[CMContext sender] setBlockToRetry:nil];
}

- (void)retryUsing:(CMBlock *)aBlock
{
  [[CMContext sender] setContinuesVisitation:NO];
  [[CMContext sender] setDoesRetry:YES];
  [[CMContext sender] setBlockToRetry:aBlock];
}

- (void)resume
{
  [(CMContext *)[CMContext sender] stop];
  [[CMContext sender] setContinuesVisitation:NO];
  [[CMContext sender] setObjectToResume:nil];
}

- (void)resume:(id)anObject
{
  [(CMContext *)[CMContext sender] stop];
  [[CMContext sender] setContinuesVisitation:NO];
  [[CMContext sender] setObjectToResume:anObject];
}

@end
