#import "NSDictionaryAdditions.h"
#import "CMBlock.h"
#import "CMDictionaryAssociation.h"

@implementation NSDictionary (CMEnumerating)

- (SEL)enumerationSelector
{
  return @selector(associationEnumerator);
}

- (NSEnumerator *)associationEnumerator
{
  id key, e;
  CMDictionaryAssociation *assoc;
  NSMutableArray *assocs;

  assocs = [NSMutableArray arrayWithCapacity:1];
  e = [self keyEnumerator];
  while (key = [e nextObject]) {
    assoc = [CMDictionaryAssociation associationWithKey:key
                                     object:[self objectForKey:key]];
    [assocs addObject:assoc];
  }

  return [assocs objectEnumerator];
}

- (void)keysDo:(CMBlock *)aBlock
{
  id key, e = [self keyEnumerator];
  while (key = [e nextObject]) {
    [aBlock value:key];
  }
}

- (void)objectsDo:(CMBlock *)aBlock
{
  id obj, e = [self objectEnumerator];
  while (obj = [e nextObject]) {
    [aBlock value:obj];
  }
}

@end
