#import "NSArrayAdditions.h"
#import "CMBlock.h"
#import "CMContext.h"


@implementation NSArray (CMEnumerating)

- (void)do:(CMBlock *)aBlock
{
  id obj, e = [self objectEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    [aBlock value:obj];
  }
}

- (void)reverseDo:(CMBlock *)aBlock
{
  id obj, e = [self reverseObjectEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    [aBlock value:obj];
  }
}

- (id)inject:(id)anObject into:(CMBlock *)aBlock
{
  id nextObject, obj, e;
  nextObject = anObject;
  e = [self objectEnumerator];
  while ((obj = [e nextObject]) && [[CMContext sender] continuesVisitation]) {
    nextObject = [aBlock value:nextObject value:obj];
  }
  return nextObject;
}

@end


