#import "common.h"
#import "CMVariable.h"
#import "CMVariableStore.h"


@implementation CMVariableStore

- (id)init
{
  [super init];
  variables = [[NSMutableArray alloc] init];
  return self;
}

- (void)dealloc
{
  [variables release];
  [parent release];
  [super dealloc];
}

- (CMVariableStore *)parentVariableStore { return parent; }
- (void)setParentVariableStore:(CMVariableStore *)aVariableStore
{
  ASSIGN(parent, aVariableStore);
}

- (NSArray *)variables { return variables; }

- (void)addVariableForName:(NSString *)aName
{
  id obj, e = [variables objectEnumerator];
  while (obj = [e nextObject]) {
    if ([[obj name] isEqualToString:aName])
      return;
  }
  [variables addObject:[CMVariable variableWithName:aName]];
}

- (void)addVariablesForNames:(NSArray *)names
{
  id name, e = [names objectEnumerator];
  while (name = [e nextObject]) {
    [self addVariableForName:name];
  }
}

// set̂Q́AXgAǂĒT
- (CMVariable *)variableNamed:(NSString *)aName
{
  id e, var, store = self;

  LOG(@"* search variable '%@'", aName);
  while (store) {
    LOG(@"    ... in %@", [store description]);
    e = [[store variables] objectEnumerator];
    while (var = [e nextObject]) {
      if ([aName isEqualToString:[var name]]) {
        LOG(@"    ... found");
        return var;
      }
    }
    store = [store parentVariableStore];
  }
  LOG(@"    ... not found");
  return nil;
}

- (void)setObject:(id)anObject forVariableNamed:(NSString *)aName
{
  CMVariable *variable = [self variableNamed:aName];
  if (!variable) {
    [self addVariableForName:aName];
    variable = [self variableNamed:aName];
  }
  [variable setObject:anObject];
}

- (void)setObject:(id)anObject forNewVariableNamed:(NSString *)aName
{
  CMVariable *variable;

  [self addVariableForName:aName];
  variable = [self variableNamed:aName];
  [variable setObject:anObject];
}

- (id)objectForVariableNamed:(NSString *)aName
{
  CMVariable *variable = [self variableNamed:aName];
  return [variable object];
}

- (void)clearVariables
{
  [variables removeAllObjects];
}

@end
