#import <Cocoa/Cocoa.h>
@class CMVariable;

@interface CMVariableStore : NSObject {
    NSMutableArray *variables;
    CMVariableStore *parent;
}

- (id)init;
- (void)dealloc;

- (CMVariableStore *)parentVariableStore;
- (void)setParentVariableStore:(CMVariableStore *)aVariableStore;

- (NSArray *)variables;
- (void)addVariableForName:(NSString *)aName;
- (void)addVariablesForNames:(NSArray *)names;
- (CMVariable *)variableNamed:(NSString *)aName;
- (void)setObject:(id)anObject forVariableNamed:(NSString *)aName;
- (void)setObject:(id)anObject forNewVariableNamed:(NSString *)aName;
- (id)objectForVariableNamed:(NSString *)aName;

- (void)clearVariables;

@end
