#import "common.h"
#import "CMVariableNode.h"
#import "CMVariable.h"
#import "CMTrue.h"
#import "CMFalse.h"
#import "CMToken.h"
#import "CMApplication.h"

@implementation CMVariableNode

+ (id)nodeWithOperatorString:(NSString *)aString
{
  id node = [[[self alloc] init] autorelease];
  if ([aString isEqualToString:@"+"]) {
    [node setIsClassVariable:YES];
  } else if ([aString isEqualToString:@"-"]) {
    [node setIsInstanceVariable:YES];
  } else {
    // error
  }
  return node;
}

+ (id)nodeWithName:(NSString *)aName
{
  CMVariableNode *obj = [[[self alloc] init] autorelease];
  [obj setName:aName];
  return obj;
}

- (void)dealloc
{
  [name release];
  [variable release];
  [super dealloc];
}

- (CMVariable *)variable { return variable; }
- (void)setVariable:(CMVariable *)aVariable { ASSIGN(variable, aVariable); }

- (NSString *)name { return name; }

- (void)setName:(NSString *)aName
{
  aName = [aName copy];
  [name release];
  name = aName;
}

- (BOOL)isNamed
{
  return (name != nil);
}

- (BOOL)isClassVariable
{
  return (!isInstanceVariable && !isLocalVariable);
}

- (BOOL)isInstanceVariable
{
  return (isInstanceVariable && !isLocalVariable);
}

- (BOOL)isLocalVariable { return isLocalVariable; }

- (void)setIsClassVariable:(BOOL)flag
{
  isInstanceVariable = !flag;
  isLocalVariable = NO;
}

- (void)setIsInstanceVariable:(BOOL)flag
{
  isInstanceVariable = flag;
  isLocalVariable = NO;
}

- (void)setIsLocalVariable:(BOOL)flag
{
  isLocalVariable = flag;
  isInstanceVariable = NO;
}

- (NSString *)ownDescription
{
  NSString *varType = @"";
  if (isInstanceVariable) {
    varType = @"-";
  } else {
    varType = @"+";
  }
  return [NSString stringWithFormat:@"%@%@", varType, name];
}

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitVariableNode");
  [aVisitor visitVariableNode:self];
  LOG(@"<== visitVariableNode");
}

- (BOOL)isSelf        { return [name isEqualToString:SelfReservedWord]; }
- (BOOL)isSuper       { return [name isEqualToString:SuperReservedWord]; }
- (BOOL)isThisContext { return [name isEqualToString:@"thisContext"]; }
- (BOOL)isNil         { return [name isEqualToString:NilReservedWord]; }
- (BOOL)isTrue        { return [name isEqualToString:TrueReservedWord]; }
- (BOOL)isFalse       { return [name isEqualToString:FalseReservedWord]; }
- (BOOL)isFileName    { return [name isEqualToString:CMFileNameVariableName]; }
- (BOOL)isLineNumber  { return [name isEqualToString:CMLineNumberVariableName]; }

- (BOOL)isPseudoVariable
{
  return ([self isSelf] || [self isSuper] || [self isThisContext] ||
          [self isNil] || [self isTrue] || [self isFalse] ||
          [self isFileName] || [self isLineNumber]);
}

@end
