#import <Cocoa/Cocoa.h>
#import "CMNode.h"
#import "CMNodeVisitor.h"

@class CMVariable;

@class CMBoolean;

@interface CMVariableNode : CMNode {
  BOOL isInstanceVariable, isLocalVariable;
  NSString *name;
  CMVariable *variable;
}

+ (id)nodeWithOperatorString:(NSString *)aString;
+ (id)nodeWithName:(NSString *)aName;

- (void)dealloc;

- (NSString *)name;
- (void)setName:(NSString *)aName;
- (BOOL)isNamed;
- (BOOL)isClassVariable;
- (void)setIsClassVariable:(BOOL)flag;
- (BOOL)isInstanceVariable;
- (void)setIsInstanceVariable:(BOOL)flag;
- (BOOL)isLocalVariable;
- (void)setIsLocalVariable:(BOOL)flag;
- (CMVariable *)variable;
- (void)setVariable:(CMVariable *)aVariable;

- (BOOL)isSelf;
- (BOOL)isSuper;
- (BOOL)isThisContext;
- (BOOL)isNil;
- (BOOL)isTrue;
- (BOOL)isFalse;
- (BOOL)isPseudoVariable;
- (BOOL)isFileName;
- (BOOL)isLineNumber;

- (NSString *)ownDescription;

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor;

@end
