#import "common.h"
#import "CMVariableDeclarationNode.h"
#import "CMNodeVisitor.h"

@implementation CMVariableDeclarationNode

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitVariableDeclarationNode");
  [aVisitor visitVariableDeclarationNode:self];
  LOG(@"<== visitVariableDeclarationNode");
}

- (NSString *)description
{
  NSMutableString *desc = [NSMutableString stringWithFormat:@"(%@ (",
                                           [[self class] nodeName]];
    
  id e = [nodes objectEnumerator];
  id obj;
  NSMutableArray *nodesDesc = [NSMutableArray arrayWithCapacity:[nodes count]];
  while (obj = [e nextObject]) {
    [nodesDesc addObject:[NSString stringWithFormat:@"\"%@\"",
                                   [obj ownDescription]]];
  }
  [desc appendString:[nodesDesc componentsJoinedByString:@" "]];
  [desc appendString:@"))"];
  return desc;
}

+ (NSString *)nodeName { return @"declare"; }

@end
