#import "common.h"
#import "CMVariable.h"
#import "CMMethod.h"
#import "CMObject.h"
#import "CMToken.h"
#import "CMApplication.h"
#import "CMTrue.h"
#import "CMFalse.h"
#import "CMNil.h"
#import "CMMethodProxy.h"

@implementation CMVariable

+ (id)selfVariableWithObject:(id)anObject
{
  return [self variableWithName:SelfReservedWord
               object:anObject
               isSubstitutable:NO];
}

+ (id)superVariableWithObject:(id)anObject
{
  return [self variableWithName:SuperReservedWord
               object:anObject
               isSubstitutable:NO];
}

+ (id)thisContextVariableWithObject:(id)anObject
{
  return [self variableWithName:@"thisContext"
               object:anObject
               isSubstitutable:NO];
}

+ (id)trueVariable
{
  return [self variableWithName:TrueReservedWord
               object:[CMTrue defaultTrue]
               isSubstitutable:NO];
}

+ (id)falseVariable
{
  return [self variableWithName:FalseReservedWord
               object:[CMFalse defaultFalse]
               isSubstitutable:NO];
}

+ (id)nilVariable
{
  return [self variableWithName:NilReservedWord
               object:[CMNil defaultNil]
               isSubstitutable:NO];
}

+ (id)fileNameVariableWithObject:(id)anObject
{
  return [self variableWithName:CMFileNameVariableName
               object:anObject
               isSubstitutable:NO];
}

+ (id)lineNumberVariableWithObject:(id)anObject
{
  return [self variableWithName:CMLineNumberVariableName
               object:anObject
               isSubstitutable:NO];
}

+ (id)variableWithName:(NSString *)aName
{
  return [[[self alloc] initWithName:aName] autorelease];
}

+ (id)variableWithName:(NSString *)aName object:(id)anObject
{
  return [[[self alloc] initWithName:aName object:anObject] autorelease];
}

+ (id)variableWithName:(NSString *)aName
                object:(id)anObject
       isSubstitutable:(BOOL)flag
{
  return [[[self alloc] initWithName:aName
                        object:anObject
                        isSubstitutable:flag] autorelease];
}

+ (id)variablesWithNames:(NSArray *)names
{
  id e, varName, variables;
  variables = [NSMutableArray array];
  e = [names objectEnumerator];
  while (varName = [e nextObject]) {
    [variables addObject:
                 [[[CMVariable alloc] initWithName:varName] autorelease]];
  }
  return variables;
}

- (id)init
{
  [super init];
  return self;
}

- (id)initWithName:(NSString *)aName
{
  return [self initWithName:aName object:nil isSubstitutable:YES];
}

- (id)initWithName:(NSString *)aName object:(id)anObject
{
  return [self initWithName:aName object:anObject isSubstitutable:YES];
}

- (id)initWithName:(NSString *)aName object:(id)anObject isSubstitutable:(BOOL)flag
{
  [self init];
  name = [[NSString alloc] initWithString:aName];
  object = [anObject retain];
  isSubstitutable = flag;
  return self;
}

- (void)dealloc
{
  [name release];
  [object release];
  [super dealloc];
}

- (NSString *)name { return name; }

- (void)setName:(NSString *)aName
{
  [name release];
  name = [[NSString alloc] initWithString:aName];
}

- (id)object { return object; }
- (void)setObject:(id)anObject { ASSIGN(object, anObject); }
- (BOOL)isSubstitutable { return isSubstitutable; }

- (void *)objectPointer
{
  return &object;
}

- (CMMethod *)getterMethodForInstanceVariable
{
  return [CMMethod methodWithName:name
                   selector:@selector(_objectOfVariable)
                   forObject:[CMMethodProxy defaultMethodProxy]];
}

- (CMMethod *)setterMethodForInstanceVariable
{
  NSString *first, *other, *setter;
  first = [[name substringToIndex:1] capitalizedString];
  other = [name substringFromIndex:1];
  setter = [NSString stringWithFormat:@"set%@%@:", first, other];
  return [CMMethod methodWithName:setter
                   selector:@selector(_setVariableToObject:)
                   forObject:[CMMethodProxy defaultMethodProxy]];
}

@end
