#import <Cocoa/Cocoa.h>

@class CMMethod;

@interface CMVariable : NSObject {
    NSString *name;
    id object;
    BOOL isSubstitutable;
}

+ (id)selfVariableWithObject:(id)anObject;
+ (id)superVariableWithObject:(id)anObject;
+ (id)thisContextVariableWithObject:(id)anObject;
+ (id)trueVariable;
+ (id)falseVariable;
+ (id)nilVariable;
+ (id)fileNameVariableWithObject:(id)anObject;
+ (id)lineNumberVariableWithObject:(id)anObject;

+ (id)variableWithName:(NSString *)aName;
+ (id)variableWithName:(NSString *)aName object:(id)anObject;
+ (id)variableWithName:(NSString *)aName object:(id)anObject isSubstitutable:(BOOL)flag;
+ (id)variablesWithNames:(NSArray *)names;

- (id)init;
- (id)initWithName:(NSString *)aName;
- (id)initWithName:(NSString *)aName object:(id)anObject;
- (id)initWithName:(NSString *)aName object:(id)anObject isSubstitutable:(BOOL)flag;
- (void)dealloc;

- (NSString *)name;
- (void)setName:(NSString *)aName;
- (id)object;
- (void)setObject:(id)anObject;
- (void *)objectPointer;
- (BOOL)isSubstitutable;

- (CMMethod *)getterMethodForInstanceVariable;
- (CMMethod *)setterMethodForInstanceVariable;

@end
