#import <Cocoa/Cocoa.h>

#define ClassReservedWord   @"class"
#define EndReservedWord     @"end"
#define AndReservedWord     @"and"
#define OrReservedWord      @"or"
#define NotReservedWord     @"not"
#define ImportReservedWord  @"import"
#define ReturnReservedWord  @"return"
#define ImmutablePrefix     @"@"
#define MutablePrefix       @"#"
#define TrueReservedWord    @"true"
#define FalseReservedWord   @"false"
#define NilReservedWord     @"nil"
#define SelfReservedWord    @"self"
#define SuperReservedWord   @"super"


@interface CMToken : NSObject {
    NSMutableString *tokenString;
    NSString *prefixContent;
    BOOL isDigitLiteral;
    int lineNumber;
    NSArray *regexpOptions;
}

+ (id)tokenWithString:(NSString *)aString;

+ (NSString *)classReservedWord;
+ (NSString *)endReservedWord;
+ (NSCharacterSet *)identifierCharacterSet;
+ (NSCharacterSet *)operatorMessageCharacterSet;
+ (NSCharacterSet *)terminateCharacterSet;
+ (NSCharacterSet *)newLineCharacterSet;
+ (NSCharacterSet *)escapeCharacterSet;
+ (NSCharacterSet *)regularExpressionOptionCharacterSet;
+ (NSArray *)allTokenCharacterSets;
+ (NSArray *)allTokenStrings;

- (id)initWithString:(NSString *)aString;
- (void)dealloc;

- (int)lineNumber;
- (void)setLineNumber:(int)number;
- (NSArray *)regularExpressionOptions;
- (void)setRegularExpressionOptions:(NSArray *)options;
- (NSString *)selectorString;

- (NSString *)prefixContent;
- (void)setPrefixContent:(NSString *)aString;
- (NSString *)tokenString;
- (void)appendTokenString:(NSString *)aString;
- (NSString *)description;
- (NSString *)unquotedString;

- (BOOL)isClassReservedWord;
- (BOOL)isEndReservedWord;
- (BOOL)isAndReservedWord;
- (BOOL)isOrReservedWord;
- (BOOL)isNotReservedWord;
- (BOOL)isReturnReservedWord;
- (BOOL)isImportReservedWord;

- (BOOL)isStringLiteral;
- (BOOL)isDigitLiteral;
- (void)setIsDigitLiteral:(BOOL)flag;
- (BOOL)isAssociationLiteral;
- (BOOL)isRegularExpressionLiteral;
- (BOOL)isSelectorLiteral;

- (BOOL)isOpenParenthesis;
- (BOOL)isCloseParenthesis;
- (BOOL)isOpenBracket;
- (BOOL)isCloseBracket;
- (BOOL)isOpenBrace;
- (BOOL)isCloseBrace;
- (BOOL)isOpen;
- (BOOL)isClose;
- (BOOL)isPair:(CMToken *)aToken;

- (BOOL)isIdentifier;
- (BOOL)isSubstituteOperatorString;
- (BOOL)isWhitespace;
- (BOOL)isNewLine;
- (BOOL)isSemicolon;
- (BOOL)isColon;
- (BOOL)isComma;
- (BOOL)isDot;
- (BOOL)isVerticalBar;
- (BOOL)isComment;
- (BOOL)isAtStartOfMethod;
- (BOOL)isTerminate;
- (BOOL)isAllCharactersOfSet:(NSCharacterSet *)aSet;
- (BOOL)isMessage;
- (BOOL)isOperatorMessage;
- (BOOL)isPlusOperatorMessage;
- (BOOL)isMinusOperatorMessage;
- (BOOL)isMutablePrefix;
- (BOOL)isImmutablePrefix;
- (BOOL)isInstanceOperator;
- (BOOL)isClassOperator;
- (BOOL)isEscape;

- (BOOL)isSingleMessage;
- (BOOL)isBinaryMessage;
- (BOOL)isKeywordMessage;
- (unsigned int)numberOfArguments;

- (BOOL)isEqualToToken:(CMToken *)aToken;
- (NSComparisonResult)compare:(CMToken *)aToken;
- (int)leftPriority;
- (int)rightPriority;
- (int)equalPriority;

- (NSString *)sourceCode;

@end

