#import <Cocoa/Cocoa.h>

#define CMMutableArrayNodeMark         [NSMutableArray class]
#define CMImmutableArrayNodeMark       [NSArray class]
#define CMMutableDictionaryNodeMark    [NSMutableDictionary class]
#define CMImmutableDictionaryNodeMark  [NSDictionary class]
#define CMExpressionNodeMark           [CMExpressionNode class]
#define CMBlockNodeMark                [CMBlockNode class]

@class CMNode, CMMessageNode, CMArrayNode, CMDictionaryNode, CMSubstituteNode,
  CMReturnNode, CMBlockNode;

@interface CMSyntaxRule : NSObject {
  NSMutableArray *ops, *outs;
  BOOL isConcatenateKeywordMessage;
}

+ (id)ruleWithOperandStack:(NSMutableArray *)opStack
               outputStack:(NSMutableArray *)outStack;

- (id)initWithOperandStack:(NSMutableArray *)opStack
               outputStack:(NSMutableArray *)outStack;
- (void)dealloc;

- (NSArray *)operandStack;
- (NSArray *)outputStack;

- (void)compositeWithOperandStack:(NSMutableArray *)opStack
                      outputStack:(NSMutableArray *)outStack;

- (void)setLeft:(CMNode *)aNode;
- (int)priority;
- (BOOL)requiresNodes;
- (void)returnTokensToOperandStack:(NSMutableArray *)opStack
                       outputStack:(NSMutableArray *)outStack;
- (void)takeNodesFromOperandStack:(NSMutableArray *)opStack
                      outputStack:(NSMutableArray *)outStack;
- (void)reduceToStack:(NSMutableArray *)aStack;

- (void)reduceMessageNodeToStack:(NSMutableArray *)aStack;
- (void)reduceElementNodeToStack:(NSMutableArray *)aStack;
- (void)reduceArrayOrExpressionNodeToStack:(NSMutableArray *)aStack;
- (void)reduceDictionaryNodeToStack:(NSMutableArray *)aStack;
- (void)reduceSubstituteNodeToStack:(NSMutableArray *)aStack;
- (void)reduceReturnNodeToStack:(NSMutableArray *)aStack;
- (void)reduceTerminateToStack:(NSMutableArray *)aStack;

@end
