#import "common.h"
#import "CMSubstituteNode.h"
#import "CMExpressionNode.h"
#import "CMNodeVisitor.h"

@implementation CMSubstituteNode

+ (id)nodeWithNode:(CMNode *)aNode
    expressionNode:(CMExpressionNode *)anExpressionNode
{
  id obj = [self node];
  [obj addNode:aNode];
  [obj addNode:anExpressionNode];
  return obj;
}

+ (id)nodeWithName:(NSString *)aName expressionNode:(CMExpressionNode *)aNode
{
  return [[[self alloc] initWithName:aName expressionNode:aNode] autorelease];
}

+ (id)nodeWithName:(NSString *)aName
{
  return [[[self alloc] initWithName:aName] autorelease];
}

- (id)initWithName:(NSString *)aName expressionNode:(CMExpressionNode *)aNode
{
  [self init];
  name = [aName retain];
  node = [aNode retain];
  return self;
}

- (id)initWithName:(NSString *)aName
{
  [self init];
  name = [aName retain];
  return self;
}

- (void)dealloc
{
  [name release];
  [node release];
  [super dealloc];
}

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitSubstituteNode");
  [aVisitor visitSubstituteNode:self];
  LOG(@"<== visitSubstituteNode");
}

@end
