#import "CMStruct.h"


@implementation CMStruct

+ (id)structWithStruct:(const void *)aValue
{
  return [[[self alloc] initWithStruct:aValue] autorelease];
}

- (id)initWithStruct:(const void *)aValue
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (id)init
{
  [super init];
  valueDict = [[NSMutableDictionary alloc] initWithCapacity:1];
  return self;
}

- (void)dealloc
{
  [valueDict release];
  [super dealloc];
}

- (id)objectForKey:(NSString *)aKey
{
  return [valueDict objectForKey:aKey];
}

- (void)setObject:(id)anObject forKey:(NSString *)aKey;
{
  [valueDict setObject:anObject forKey:aKey];
}

- (id)valueForKey:(NSString *)aKey
{
  id value = [self objectForKey:aKey];
  if (value)
    return value;
  return [super valueForKey:aKey];
}

- (void)setValue:(id)aValue forKey:(NSString *)aKey
{
  id value = [self objectForKey:aKey];
  if (value)
    [self setObject:aValue forKey:aKey];
  else
    [super setValue:aValue forKey:aKey];
}

- (NSString *)description
{
  return [valueDict description];
}

@end
