#import "common.h"
#import "CMStringNode.h"


@implementation CMStringNode

+ (id)nodeWithString:(NSString *)aString
{
  return [[[self alloc] initWithString:aString] autorelease];
}

- (id)initWithString:(NSString *)aString
{
  [self init];
  string = [[NSString alloc] initWithString:aString];
  return self;
}

- (void)dealloc
{
  [string release];
  [super dealloc];
}

- (NSString *)ownDescription
{
  return [NSString stringWithFormat:@"%@%@", [self mutablePrefix], string];
}

- (NSString *)string { return string; }

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitStringNode");
  [aVisitor visitStringNode:self];
  LOG(@"<== visitStringNode");
}


@end
