#import "common.h"
#import "CMObjCTypeConverter.h"
#import "CMSmallInteger.h"
#import "CMLargeInteger.h"
#import "CMFloat.h"
#import "CMException.h"

@implementation CMSmallInteger

+ (id)zero
{
  return [self integerWithLong:0];
}

+ (id)integerWithLong:(long)aValue
{
  return [[[self alloc] initWithLong:aValue] autorelease];
}

- (id)initWithLong:(long)aValue
{
  [self init];
  value = aValue;
  return self;
}

- (NSString *)description
{
  return [NSString stringWithFormat:@"%d", value];
}

- (short)shortValue                  { return (short)value; }
- (unsigned short)unsignedShortValue { return (unsigned short)value; }
- (int)intValue                      { return (int)value; }
- (unsigned int)unsignedIntValue     { return (unsigned int)value; }
- (long)longValue                    { return value; }
- (double)doubleValue                { return (double)value; }

- (unsigned)hash
{
  return (unsigned)value;
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_SHORT(objCType)) {
    static short val;
    val = [self shortValue];
    return &val;
  } else if (IS_ENCODE_USHORT(objCType)) {
    static unsigned short val;
    val = [self unsignedShortValue];
    return &val;
  } else if (IS_ENCODE_INT(objCType)) {
    static int val;
    val = [self intValue];
    return &val;
  } else if (IS_ENCODE_UINT(objCType)) {
    static unsigned int val;
    val = [self unsignedIntValue];
    return &val;
  } else if (IS_ENCODE_LONG(objCType)) {
    static long val;
    val = [self longValue];
    return &val;
  }

  return [super objCValueWithType:objCType];
}

- (CMLargeInteger *)largeInteger
{
  return [CMLargeInteger integerWithLongLong:(long long)value];
}

- (CMFloat *)float
{
  return [CMFloat floatWithDouble:(double)value];
}

- (id)negated
{
  return [[self class] integerWithLong:0-value];
}

- (BOOL)isZero
{
  return value == 0;
}

- (CMInteger *)integer
{
  return self;
}

- (NSComparisonResult)compareCMSmallInteger:(CMSmallInteger *)anInteger
{
  long left, right;

  left = [self longValue];
  right = [anInteger longValue];
  if (left < right)
    return NSOrderedAscending;
  else if (left > right)
    return NSOrderedDescending;
  else
    return NSOrderedSame;
}

- (NSComparisonResult)compareCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger]
           compareCMLargeInteger:anInteger];
}

- (NSComparisonResult)compareCMFloat:(CMFloat *)aFloat
{
  return [[self float] compareCMFloat:aFloat];
}

- (id)objectByAddingCMSmallInteger:(CMSmallInteger *)anInteger
{
  long a, b, c;
  id r;

  a = value;
  b = [anInteger longValue];
  c = a + b;
  r = PLNG2SINT(c);
  if ([r longValue] != c) {
    r = [[self largeInteger]
          objectByAddingCMLargeInteger:[anInteger largeInteger]];
  }
  return r;
}

- (id)objectByAddingCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger]
           objectByAddingCMLargeInteger:anInteger];
}

- (id)objectByAddingCMFloat:(CMFloat *)aFloat
{
  return [[self float] objectByAddingCMFloat:aFloat];
}

- (id)objectBySubtractingCMSmallInteger:(CMSmallInteger *)anInteger
{
  long a, b, c;
  id r;

  a = value;
  b = [anInteger longValue];
  c = a - b;
  r = PLNG2SINT(c);
  if ([r longValue] != c) {
    r = [[self largeInteger]
          objectBySubtractingCMLargeInteger:[anInteger largeInteger]];
  }
  return r;
}

- (id)objectBySubtractingCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger]
           objectBySubtractingCMLargeInteger:anInteger];
}

- (id)objectBySubtractingCMFloat:(CMFloat *)aFloat
{
  return [[self float] objectBySubtractingCMFloat:aFloat];
}

- (id)objectByMultiplyingByCMSmallInteger:(CMSmallInteger *)anInteger
{
  long a, b, c;
  id r;

  a = value;
  if (a == 0) return self;
  b = [anInteger longValue];
  c = a * b;
  r = PLNG2SINT(c);
  if ([r longValue] != c || c/a != b) {
    r = [[self largeInteger]
          objectByMultiplyingByCMLargeInteger:[anInteger largeInteger]];
  }
  return r;
}

- (id)objectByMultiplyingByCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger]
           objectByMultiplyingByCMLargeInteger:anInteger];
}

- (id)objectByMultiplyingByCMFloat:(CMFloat *)aFloat
{
  return [[self float] objectByMultiplyingByCMFloat:aFloat];
}

- (id)objectByDividingByCMSmallInteger:(CMSmallInteger *)anInteger
{
  long div;
  [self divideLong:value byLong:[anInteger longValue] withQuotient:&div modulo:0];
  return [CMNumber numberWithLong:div];
}

- (void)divideLong:(long)x
            byLong:(long)y
      withQuotient:(long *)divp
         modulo:(long *)modp
{
  long div, mod;
  if (y == 0) [CMException raiseZeroDivideException];
  if (y < 0) {
    if (x < 0)
      div = -x / -y;
    else
      div = - (x / -y);
  }
  else {
    if (x < 0)
      div = - (-x / y);
    else
      div = x / y;
  }
  mod = x - div * y;
  if ((mod < 0 && y > 0) || (mod > 0 && y < 0)) {
    mod += y;
    div -= 1;
  }
  if (divp) *divp = div;
  if (modp) *modp = mod;
}

- (id)objectByDividingByCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger]
           objectByDividingByCMLargeInteger:anInteger];
}

- (id)objectByDividingByCMFloat:(CMFloat *)aFloat
{
  return [[self float] objectByDividingByCMFloat:aFloat];
}

- (id)moduloOfDividedByCMSmallInteger:(CMSmallInteger *)anInteger
{
  long mod;
  [self divideLong:value byLong:[anInteger longValue] withQuotient:0 modulo:&mod];
  return [CMNumber numberWithLong:mod];
}

- (id)moduloOfDividedByCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger] moduloOfDividedByCMLargeInteger:anInteger];
}

- (id)moduloOfDividedByCMFloat:(CMFloat *)aFloat
{
  return [[self largeInteger] moduloOfDividedByCMFloat:aFloat];
}

- (id)objectByRaisingToPowerCMSmallInteger:(CMSmallInteger *)anInteger
{
  long a, b;

  b = [anInteger longValue];
  if (b == 0) return PINT2SINT(1);
  if (b == 1) return self;

  a = value;
  if (b > 0)
    return [[self largeInteger] objectByRaisingToPowerCMSmallInteger:anInteger];
  else
    return [CMFloat floatWithDouble:pow((double)a, (double)b)];
}

- (id)objectByRaisingToPowerCMLargeInteger:(CMLargeInteger *)anInteger
{
  return [[self largeInteger] objectByRaisingToPowerCMLargeInteger:anInteger];
}

- (id)objectByRaisingToPowerCMFloat:(CMFloat *)aFloat
{
  return [[self float] objectByRaisingToPowerCMFloat:aFloat];
}

- (id)objectByShiftingRight:(id)anObject
{
  long i, val;

  i = [anObject longValue];
  if (i < 0)
    return [self objectByShiftingLeft:PLNG2SINT(-i)];
  if (i == 0) return self;
  val = value;
  if (i >= sizeof(long)*CHAR_BIT-1) {
    if (val < 0) return PLNG2SINT(-1);
    return PLNG2SINT(0);
  }
  val = RSHIFT(val, i);
  return PLNG2SINT(val);
}

- (id)objectByShiftingLeft:(id)anObject
{
  long val, width;
  
  val = value;
  width = [anObject longValue];
  if (width < 0)
    return [self objectByShiftingRight:PLNG2SINT(-width)];
  if (width > (sizeof(id)*CHAR_BIT-1)
      || ((unsigned long)val)>>(sizeof(id)*CHAR_BIT-1-width) > 0) {
    return [PLNG2LINT(val) objectByShiftingLeft:[anObject largeInteger]];
  }
  val = val << width;
  return PLNG2SINT(val);
}

@end
