#import <Cocoa/Cocoa.h>
#import "CMInteger.h"

@class CMFloat, CMLargeInteger;

// $B@)8BIU$-$N@0?t(B
@interface CMSmallInteger : CMInteger {
  long value;
}

+ (id)zero;
+ (id)integerWithLong:(long)aValue;

- (id)initWithLong:(long)aValue;

- (NSString *)description;

- (short)shortValue;
- (unsigned short)unsignedShortValue;
- (int)intValue;
- (unsigned int)unsignedIntValue;
- (long)longValue;

- (CMLargeInteger *)largeInteger;
- (CMFloat *)float;

- (NSComparisonResult)compareCMSmallInteger:(CMSmallInteger *)anInteger;
- (NSComparisonResult)compareCMLargeInteger:(CMLargeInteger *)anInteger;
- (NSComparisonResult)compareCMFloat:(CMFloat *)aFloat;

- (id)objectByAddingCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByAddingCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByAddingCMFloat:(CMFloat *)aFloat;

- (id)objectBySubtractingCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectBySubtractingCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectBySubtractingCMFloat:(CMFloat *)aFloat;

- (id)objectByMultiplyingByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByMultiplyingByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByMultiplyingByCMFloat:(CMFloat *)aFloat;

- (id)objectByDividingByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByDividingByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByDividingByCMFloat:(CMFloat *)aFloat;
- (void)divideLong:(long)x
            byLong:(long)y
      withQuotient:(long *)divp
            modulo:(long *)modp;

- (id)moduloOfDividedByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)moduloOfDividedByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)moduloOfDividedByCMFloat:(CMFloat *)aFloat;

- (id)objectByRaisingToPowerCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByRaisingToPowerCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByRaisingToPowerCMFloat:(CMFloat *)aFloat;

@end


