#import "common.h"
#import "CMSize.h"
#import "CMObjCTypeConverter.h"

static id zeroSize = nil;

@implementation CMSize

+ (id)zeroSize
{
  if (!zeroSize)
    zeroSize = [[self alloc] initWithStruct:&NSZeroSize];
  return zeroSize;
}

+ (id)size
{
  return [[[self alloc] init] autorelease];
}

+ (id)sizeWithWidth:(float)width height:(float)height
{
  return [[[self alloc] initWithWidth:width height:height] autorelease];
}

- (id)initWithWidth:(float)width height:(float)height
{
  [self init];
  [self setWidth:width];
  [self setHeight:height];
  return self;
}

- (id)initWithStruct:(const void *)aValue
{
  [self init];
  NSSize *value = (NSSize *)aValue;
  [self setWidth:(value->width)];
  [self setHeight:(value->height)];
  return self;
}

+ (const char *)objCType 
{
  return @encode(NSSize);
}

- (const void *)objCValue
{
  static NSSize value;
  value = [self sizeValue];
  return &value;
}

- (float)width
{
  return [[self objectForKey:CMSizeWidthKey] floatValue];
}

- (void)setWidth:(float)width
{
  [self setObject:PFLT2FLT(width) forKey:CMSizeWidthKey];
}

- (float)height
{
  return [[self objectForKey:CMSizeHeightKey] floatValue];
}

- (void)setHeight:(float)height
{
  [self setObject:PFLT2FLT(height) forKey:CMSizeHeightKey];
}

- (NSSize)sizeValue
{
  return NSMakeSize([self width], [self height]);
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_SIZE(objCType)) {
    static NSSize val;
    val = [self sizeValue];
    return &val;
  }
  return [super objCValueWithType:objCType];
}

@end
