#import "common.h"
#import "CMSelectorNode.h"


@implementation CMSelectorNode

+ (id)nodeWithString:(NSString *)aString
{
  return [[[self alloc] initWithString:aString] autorelease];
}

+ (id)nodeWithSelector:(SEL)aSelector
{
  return [[[self alloc] initWithSelector:aSelector] autorelease];
}

- (id)initWithString:(NSString *)aString
{
  [super init];
  selector = NSSelectorFromString(aString);
  return self;
}

- (id)initWithSelector:(SEL)aSelector
{
  [super init];
  selector = aSelector;
  return self;
}

- (id)init
{
  [super init];
  string = [[NSMutableString alloc] initWithCapacity:1];
  return self;
}

- (void)dealloc
{
  [string release];
  [super dealloc];
}

- (NSString *)ownDescription
{
  return NSStringFromSelector(selector);
}

- (SEL)selector { return selector; }

- (void)appendString:(NSString *)aString
{
  [string appendString:aString];
}

- (void)convertStringToSelector
{
  selector = NSSelectorFromString(string);
}

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitSelectorNode");
  [aVisitor visitSelectorNode:self];
  LOG(@"<== visitSelectorNode");
}

@end
