#import "common.h"
#import "CMSelector.h"
#import "CMObjCTypeConverter.h"

static NSMutableDictionary *selDict = nil;

@implementation CMSelector

+ (NSMutableDictionary *)selectorDictionary
{
  return selDict;
}

+ (id)selectorForSelector:(SEL)aSelector
{
  id obj;
  NSString *str = NSStringFromSelector(aSelector);

  if (!selDict)
    selDict = [[NSMutableDictionary alloc] initWithCapacity:1];

  if (!(obj = [selDict objectForKey:str])) {
    obj = [self selectorWithSelector:aSelector];
    [selDict setObject:obj forKey:str];
  }

  return obj;
}

+ (id)selectorWithSelector:(SEL)aSelector
{
  return [[[self alloc] initWithSelector:aSelector] autorelease];
}

- (id)initWithSelector:(SEL)aSelector
{
  [self init];
  selector = aSelector;
  return self;
}

- (NSString *)stringValue
{
  return NSStringFromSelector(selector);
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_SEL(objCType)) {
    static SEL sel;
    sel = selector;
    return &sel;

  } else if (IS_ENCODE_CHARP(objCType)) {
    static const char *val;
    val = [NSStringFromSelector(selector) cString];
    return &val;
  }

  return [super objCValueWithType:objCType];
}

- (NSString *)description
{
  return [NSString stringWithFormat:@"@selector(%@)", NSStringFromSelector(selector)];
}

@end
