#import <Cocoa/Cocoa.h>
#import "CMContext.h"
#import "CMApplication.h"

@interface CMRuntime : CMContext {
  CMApplication *app;
  NSString *loadingFileName;
  NSMutableArray *loadPaths, *loadedPaths;
}

+ (id)defaultRuntime;

- (void)initializeLoadPaths;

- (NSMutableArray *)loadPaths;
- (NSString *)loadingFileName;
- (void)setLoadingFileName:(NSString *)aName;

- (void)loadWithPath:(NSString *)path;
- (void)loadWithPath:(NSString *)path reload:(BOOL)flag;
- (id)loadFromStandardInput;
- (id)loadWithContentsOfFile:(NSString *)aFileName;
- (id)loadWithString:(NSString *)aString;
- (void)loadAllFilesInDirectoryAtPath:(NSString *)path;
- (void)loadAllFilesInCurrectDirectoryPath;

- (id)evaluate:(NSString *)aString;
- (BOOL)loadsCurrentFile;

@end
