#import "common.h"
#import "CMRegularExpressionNode.h"
#import <OgreKit/OgreKit.h>

#define CMRegularExpressionInvalidOptionExreption \
  @"CMRegularExpressionInvalidOptionExreption"

#define CMSingleLineOption           @"s"
#define CMMultilineOption            @"m"
#define CMIgnoreCaseOption           @"i"
#define CMExtendOption               @"x"
#define CMFindLongestOption          @"l"
#define CMFindNotEmptyOption         @"e"
#define CMNegateSingleLineOption     @"n"
#define CMDontCaptureGroupOption     @"c"
#define CMDelimitByWhitespaceOption  @"w"

#define CMPOSIXBasicSyntax           @"O"
#define CMPOSIXExtendedSyntax        @"X"
#define CMEmacsSyntax                @"E"
#define CMGrepSyntax                 @"G"
#define CMGNURegexSyntax             @"N"
#define CMPerlSyntax                 @"P"
#define CMRubySyntax                 @"R"
#define CMSimpleMatchingSyntax       @"S"

#define CMBackslashCharacter         @"B"
#define CMGUIYenCharacter            @"Y"


@implementation CMRegularExpressionNode

+ (id)nodeWithString:(NSString *)aString optionArray:(NSArray *)anArray
{
  return [[[self alloc] initWithString:aString optionArray:anArray] autorelease];
}

- (id)initWithString:(NSString *)aString optionArray:(NSArray *)anArray
{
  [self init];
  NSRange range = NSMakeRange(1, [aString length] - 2);
  string = [[aString substringWithRange:range] retain];
  optionArray = [anArray retain];
  return self;
}

- (id)init
{
  [super init];
  options = OgreNoneOption;
  syntax = OgreRubySyntax;
  escapeCharacter = OgreBackslashCharacter;
  return self;
}

- (void)dealloc
{
  [string release];
  [optionArray release];
  [super dealloc];
}

- (void)parseOptions
{
  id e, option;

  e = [optionArray objectEnumerator];
  while (option = [e nextObject]) {
    if ([option isEqualToString:CMSingleLineOption])
      options = options | OgreSingleLineOption;
    else if ([option isEqualToString:CMMultilineOption])
      options = options | OgreMultilineOption;
    else if ([option isEqualToString:CMIgnoreCaseOption])
      options = options | OgreIgnoreCaseOption;
    else if ([option isEqualToString:CMExtendOption])
      options = options | OgreExtendOption;
    else if ([option isEqualToString:CMFindLongestOption])
      options = options | OgreFindLongestOption;
    else if ([option isEqualToString:CMFindNotEmptyOption])
      options = options | OgreFindNotEmptyOption;
    else if ([option isEqualToString:CMNegateSingleLineOption])
      options = options | OgreNegateSingleLineOption;
    else if ([option isEqualToString:CMDontCaptureGroupOption])
      options = options | OgreDontCaptureGroupOption;
    else if ([option isEqualToString:CMDelimitByWhitespaceOption])
      options = options | OgreDelimitByWhitespaceOption;
    else if ([option isEqualToString:CMPOSIXBasicSyntax])
      syntax = OgrePOSIXBasicSyntax;
    else if ([option isEqualToString:CMPOSIXExtendedSyntax])
      syntax = OgrePOSIXExtendedSyntax;
    else if ([option isEqualToString:CMEmacsSyntax])
      syntax = OgreEmacsSyntax;
    else if ([option isEqualToString:CMGrepSyntax])
      syntax = OgreGrepSyntax;
    else if ([option isEqualToString:CMGNURegexSyntax])
      syntax = OgreGNURegexSyntax;
    else if ([option isEqualToString:CMPerlSyntax])
      syntax = OgrePerlSyntax;
    else if ([option isEqualToString:CMRubySyntax])
      syntax = OgreRubySyntax;
    else if ([option isEqualToString:CMSimpleMatchingSyntax])
      syntax = OgreSimpleMatchingSyntax;
    else if ([option isEqualToString:CMBackslashCharacter])
      escapeCharacter = OgreBackslashCharacter;
    else if ([option isEqualToString:CMGUIYenCharacter])
      escapeCharacter = OgreGUIYenCharacter;
    else
      [NSException raise:CMRegularExpressionInvalidOptionExreption
                   format:@"invalid option '%@'", option];
  }
}

- (NSString *)ownDescription
{
  return string;
}

+ (NSString *)nodeName { return @"regexp"; }
- (NSString *)string { return string; }
- (NSArray *)optionArray { return optionArray; }
- (unsigned int)options { return options; }
- (OgreSyntax)syntax { return syntax; }
- (NSString *)escapeCharacter { return escapeCharacter; }

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitRegularExpressionNode");
  [aVisitor visitRegularExpressionNode:self];
  LOG(@"<== visitRegularExpressionNode");
}

@end
