#import <Cocoa/Cocoa.h>
#import <OgreKit/OGRegularExpression.h>
#import "CMLiteralNode.h"

@interface CMRegularExpressionNode : CMLiteralNode {
  NSMutableString *string;
  NSArray *optionArray;
  unsigned int options;
  OgreSyntax syntax;
  NSString *escapeCharacter;
}

+ (id)nodeWithString:(NSString *)aString optionArray:(NSArray *)anArray;

- (id)initWithString:(NSString *)aString optionArray:(NSArray *)anArray;
- (void)dealloc;
- (void)parseOptions;

- (NSString *)ownDescription;
- (NSString *)string;
- (NSArray *)optionArray;
- (unsigned int)options;
- (OgreSyntax)syntax;
- (NSString *)escapeCharacter;

@end

