#import "CMRect.h"
#import "CMPoint.h"
#import "CMSize.h"
#import "CMObjCTypeConverter.h"

static id zeroRect = nil;

@implementation CMRect

+ (id)zeroRect
{
  if (!zeroRect)
    zeroRect = [[self alloc] initWithStruct:&NSZeroRect];
  return zeroRect;
}

+ (id)rect
{
  return [[[self alloc] init] autorelease];
}

+ (id)rectWithOrigin:(NSPoint)origin size:(NSSize)size
{
  return [[[self alloc] initWithOrigin:origin size:size] autorelease];
}

+ (id)rectWithX:(float)x y:(float)y width:(float)width height:(float)height
{
  return [[[self alloc] initWithX:x y:y width:width height:height] autorelease];
}

- (id)initWithOrigin:(NSPoint)origin size:(NSSize)size
{
  [self init];
  [self setOrigin:origin];
  [self setSize:size];
  return self;
}

- (id)initWithX:(float)x y:(float)y width:(float)width height:(float)height
{
  NSPoint origin = NSMakePoint(x, y);
  NSSize size = NSMakeSize(width, height);
  return [self initWithOrigin:origin size:size];
}

- (id)initWithStruct:(const void *)aValue
{
  [self init];
  NSRect *value = (NSRect *)aValue;
  [self setOrigin:(value->origin)];
  [self setSize:(value->size)];
  return self;
}

+ (const char *)objCType 
{
  return @encode(NSRect);
}

- (const void *)objCValue
{
  static NSRect value;
  value = [self rectValue];
  return &value;
}

- (NSPoint)origin
{
  return [[self objectForKey:CMRectOriginKey] pointValue];
}

- (void)setOrigin:(NSPoint)origin
{
  CMPoint *point = [CMPoint structWithStruct:&origin];
  [self setObject:point forKey:CMRectOriginKey];
}

- (NSSize)size
{
  return [[self objectForKey:CMRectSizeKey] sizeValue];
}

- (void)setSize:(NSSize)size
{
  CMSize *obj = [CMSize structWithStruct:&size];
  [self setObject:obj forKey:CMRectSizeKey];
}

- (NSRect)rectValue
{
  return NSMakeRect([self origin].x, [self origin].y,
                    [self size].width, [self size].height);
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_RECT(objCType)) {
    static NSRect val;
    val = [self rectValue];
    return &val;
  }
  return [super objCValueWithType:objCType];
}

@end
