#import <Cocoa/Cocoa.h>
#import "CMStruct.h"

#define CMRectOriginKey @"origin"
#define CMRectSizeKey   @"size"

@interface CMRect : CMStruct {
}

+ (id)zeroRect;

+ (id)rect;
+ (id)rectWithOrigin:(NSPoint)origin size:(NSSize)size;
+ (id)rectWithX:(float)x y:(float)y width:(float)width height:(float)height;

- (id)initWithOrigin:(NSPoint)origin size:(NSSize)size;
- (id)initWithX:(float)x y:(float)y width:(float)width height:(float)height;

- (NSPoint)origin;
- (void)setOrigin:(NSPoint)origin;
- (NSSize)size;
- (void)setSize:(NSSize)size;

- (NSRect)rectValue;

@end
