#import "common.h"
#import "CMSmallInteger.h"
#import "CMRange.h"
#import "CMObjCTypeConverter.h"
#import "NSArrayAdditions.h"

@implementation CMRange

+ (id)range
{
  return [[[self alloc] init] autorelease];
}

+ (id)rangeWithLocation:(unsigned int)location length:(unsigned int)length
{
  return [[[self alloc] initWithLocation:location length:length] autorelease];
}

- (id)initWithLocation:(unsigned int)location length:(unsigned int)length
{
  [self init];
  [self setLocation:location];
  [self setLength:length];
  return self;
}

- (id)initWithStruct:(const void *)aValue
{
  [self init];
  NSRange *value = (NSRange *)aValue;
  [self setObject:PLNG2SINT(value->length) forKey:CMRangeLengthKey];
  [self setObject:PLNG2SINT(value->location) forKey:CMRangeLocationKey];
  return self;
}

+ (const char *)objCType 
{
  return @encode(NSRange);
}

- (const void *)objCValue
{
  static NSRange value;
  value = [self rangeValue];
  return &value;
}

- (unsigned int)location
{
  return [[self objectForKey:CMRangeLocationKey] unsignedIntValue];
}

- (void)setLocation:(unsigned int)location
{
  [self setObject:PLNG2SINT(location) forKey:CMRangeLocationKey];
}

- (unsigned int)length
{
  return [[self objectForKey:CMRangeLengthKey] unsignedIntValue];
}

- (void)setLength:(unsigned int)length
{
  [self setObject:PLNG2SINT(length) forKey:CMRangeLengthKey];
}

- (NSRange)rangeValue
{
  return NSMakeRange([self location], [self length]);
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_RANGE(objCType)) {
    static NSRange val;
    val = [self rangeValue];
    return &val;
  }
  return [super objCValueWithType:objCType];
}

- (id)inject:(id)anObject into:(CMBlock *)aBlock
{
  NSMutableArray *array;
  int i, location;

  location = [self location];
  array = [NSMutableArray arrayWithCapacity:1];
  for (i = 0; i < [self length]; i++)
    [array addObject:PLNG2SINT(i + location)];
  return [array inject:anObject into:aBlock];
}

@end
