#import "CMRandom.h"
#include <stdlib.h>

@implementation CMRandom

+ (double)next
{
  return [[self random] next];
}

+ (id)random
{
  return [[[self alloc] init] autorelease];
}

+ (id)randomWithSeed:(long)number
{
  return [[[self alloc] initWithSeed:number] autorelease];
}

- (id)init
{
  [super init];
  seed = (long)[NSDate timeIntervalSinceReferenceDate];
  return self;
}

- (id)initWithSeed:(long)number
{
  [super init];
  seed = number;
  return self;
}

- (double)next
{
  srand48(seed);
  return drand48();
}

- (long)seed { return seed; }
- (void)setSeed:(long)number { seed = number; }

@end
