#import "common.h"
#import "CMPoint.h"
#import "CMObjCTypeConverter.h"

static id zeroPoint = nil;

@implementation CMPoint

+ (id)zeroPoint
{
  if (!zeroPoint)
    zeroPoint = [[self alloc] initWithStruct:&NSZeroPoint];
  return zeroPoint;
}

+ (id)point
{
  return [[[self alloc] init] autorelease];
}

+ (id)pointWithX:(float)x y:(float)y
{
  return [[[self alloc] initWithX:x y:y] autorelease];
}

- (id)initWithX:(float)x y:(float)y
{
  [self init];
  [self setX:x];
  [self setY:y];
  return self;
}

- (id)initWithStruct:(const void *)aValue
{
  [self init];
  NSPoint *value = (NSPoint *)aValue;
  [self setX:(value->x)];
  [self setY:(value->y)];
  return self;
}

+ (const char *)objCType 
{
  return @encode(NSPoint);
}

- (const void *)objCValue
{
  static NSPoint value;
  value = [self pointValue];
  return &value;
}

- (float)x
{
  return [[self objectForKey:CMPointXKey] floatValue];
}

- (void)setX:(float)x
{
  [self setObject:PFLT2FLT(x) forKey:CMPointXKey];
}

- (float)y
{
  return [[self objectForKey:CMPointYKey] floatValue];
}

- (void)setY:(float)y
{
  [self setObject:PFLT2FLT(y) forKey:CMPointYKey];
}

- (NSPoint)pointValue
{
  return NSMakePoint([self x], [self y]);
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_POINT(objCType)) {
    static NSPoint val;
    val = [self pointValue];
    return &val;
  }
  return [super objCValueWithType:objCType];
}

@end
