#import <Cocoa/Cocoa.h>
@class CMLexer, CMNode, CMExpressionNode, CMClassNode, CMContext;

@interface CMParser : NSObject {
  CMLexer *lexer;
  CMNode *node;
  CMContext *context;
}

+ (CMNode *)parseWithLexer:(CMLexer *)aLexer;

- (id)initWithLexer:(CMLexer *)aLexer;
- (void)dealloc;

- (CMNode *)node;
- (void)parse;
- (CMNode *)parseExpressionWithTokens:(NSArray *)tokens
                         indexPointer:(int *)index;
- (void)compositeExpressionNodeWithOperandStack:(NSMutableArray *)opStack
                                    outputStack:(NSMutableArray *)outStack;

@end
