#import <Cocoa/Cocoa.h>

// informed protocol
// $B1i;;;R%a%=%C%I(B

#define CMOperatorPlus                  @"+"
#define CMOperatorMinus                 @"-"
#define CMOperatorTimes                 @"*"
#define CMOperatorDividedBy             @"/"
#define CMOperatorModuloOfDividedBy     @"%"
#define CMOperatorRemainderOfDividedBy  @"%%"
#define CMOperatorRaisingToPower        @"**"
#define CMOperatorEqualTo               @"=="
#define CMOperatorNotEqualTo            @"!="
#define CMOperatorGreaterThan           @">"
#define CMOperatorGreaterThanOrEqualTo  @">="
#define CMOperatorLessThan              @"<"
#define CMOperatorLessThanOrEqualTo     @"<="
#define CMOperatorCompare               @"<=>"
#define CMOperatorShiftRight            @">>"
#define CMOperatorShiftLeft             @"<<"
#define CMStringPlus                    @"objectByAdding:"
#define CMStringMinus                   @"objectBySubtracting:"
#define CMStringTimes                   @"objectByMultiplyingBy:"
#define CMStringDividedBy               @"objectByDividingBy:"
#define CMStringModuloOfDividedBy       @"moduloOfDividedBy:"
#define CMStringRemainderOfDividedBy    @"remainderOfDividedBy:"
#define CMStringRaisingToPower          @"objectByRaisingToPower:"
#define CMStringEqualTo                 @"isEqualTo:"
#define CMStringNotEqualTo              @"isNotEqualTo:"
#define CMStringGreaterThan             @"isGreaterThan:"
#define CMStringGreaterThanOrEqualTo    @"isGreaterThanOrEqualTo:"
#define CMStringLessThan                @"isLessThan:"
#define CMStringLessThanOrEqualTo       @"isLessThanOrEqualTo:"
#define CMStringCompare                 @"compare:"
#define CMStringShiftRight              @"objectByShiftingRight:"
#define CMStringShiftLeft               @"objectByShiftingLeft:"


@protocol CMOperatorMethods

- (id)objectByAdding:(id)anObject;            // +
- (id)objectBySubtracting:(id)anObject;       // -
- (id)objectByMultiplyingBy:(id)anObject;     // *
- (id)objectByDividingBy:(id)anObject;        // /
- (id)moduloOfDividedBy:(id)anObject;         // %
- (id)remainderOfDividedBy:(id)anObject;      // %%
- (id)objectByRaisingToPower:(id)anObject;    // **
- (id)objectByShiftingRight:(id)anObject;     // >>
- (id)objectByShiftingLeft:(id)anObject;      // <<

- (BOOL)isEqualTo:(id)anObject;               // ==
- (BOOL)isNotEqualTo:(id)anObject;            // !=
- (BOOL)isGreaterThan:(id)anObject;           // >
- (BOOL)isGreaterThanOrEqualTo:(id)anObject;  // >=
- (BOOL)isLessThan:(id)anObject;              // <
- (BOOL)isLessThanOrEqualTo:(id)anObject;     // <=
- (NSComparisonResult)compare:(id)anObject;   // <=>

- (id)and:(id)anObject;                       // &
- (id)or:(id)anObject;                        // |
- (id)xor:(id)anObject;                       // ^

@end
