#import "common.h"
#import "CMObject.h"
#import "CMClass.h"
#import "CMVariable.h"
#import "CMVariableStore.h"

static NSMutableDictionary *objectDict = nil;

@implementation CMObject

+ (NSMutableDictionary *)objectDictionary
{
  if (objectDict == nil)
    objectDict = [[NSMutableDictionary alloc] init];
  return objectDict;
}

+ (NSNumber *)idValueForObject:(id)anObject
{
  return [NSNumber numberWithInt:(int)anObject];
}

+ (id)objectForObject:(id)anObject
{
  NSNumber *numOfID = [self idValueForObject:anObject];
  id obj = [[self objectDictionary] objectForKey:numOfID];
  if (!obj && anObject) {
    obj = [[[[self class] alloc] initWithObject:anObject] autorelease];
    [[self objectDictionary] setObject:obj forKey:numOfID];
  }
  return obj;
}

+ (void)removeObject:(id)anObject
{
  LOG(@"* remove %@ from dictionary", [anObject description]);
  [[self objectDictionary] removeObjectForKey:
                             [self idValueForObject:anObject]];
}

- (id)init
{
  [super init];
  return self;
}

- (id)initWithObject:(id)anObject
{
  [self init];
  object = anObject; // weak reference
  if (IS_CLASS(object))
    [self addVariablesForNames:
            [[CMClass classForClass:anObject] classVariableNames]];
  else
    [self addVariablesForNames:
            [[CMClass classForObject:anObject] instanceVariableNames]];
  return self;
}

- (void)dealloc
{
  LOG(@"* dealloc wrapper for: %@", [object description]);
  [super dealloc];
}

@end


