#import "CMObjCTypeConverter.h"
#import "CMTrue.h"
#import "CMFalse.h"
#import "CMNil.h"
#import "CMRange.h"
#import "CMPoint.h"
#import "CMRect.h"
#import "CMSize.h"
#import "CMSmallInteger.h"
#import "CMLargeInteger.h"
#import "CMFloat.h"
#import "CMSelector.h"
#import "CMException.h"

@implementation CMObjCTypeConverter

// invocation̖߂lIuWFNgɕϊ
+ (id)returnValueWithInvocation:(NSInvocation *)anInvocation
{
  id value = nil;
  char bufferc;
  char *buffercp;
  long bufferl;
  unsigned long bufferL;
  long long bufferq;
  unsigned long long bufferQ;
  double bufferd;
  SEL sel;
  NSRect bufferRect;
  NSRange bufferRange;
  NSSize bufferSize;
  NSPoint bufferPoint;

  const char *type = [[anInvocation methodSignature] methodReturnType];
  unsigned int length = [[anInvocation methodSignature] methodReturnLength];

  if (IS_ENCODE_CHAR(type)) {
    [anInvocation getReturnValue:&bufferc];

    // bool
    if (bufferc == YES)
      value = [CMTrue defaultTrue];
    else if (bufferc == NO)
      value = [CMFalse defaultFalse];
    else if (bufferc)
      value = [NSString stringWithCString:&bufferc];

  } else if (IS_ENCODE_SHORT(type) || IS_ENCODE_USHORT(type) ||
             IS_ENCODE_INT(type) || IS_ENCODE_UINT(type) || IS_ENCODE_LONG(type)) {
    [anInvocation getReturnValue:&bufferl];
    value = [CMSmallInteger integerWithLong:bufferl];

  } else if (IS_ENCODE_ULONG(type)) {
    [anInvocation getReturnValue:&bufferL];
    value = [CMLargeInteger integerWithUnsignedLongLong:bufferL sign:true];

  } else if (IS_ENCODE_LONGLONG(type)) {
    [anInvocation getReturnValue:&bufferq];
    value = [CMLargeInteger integerWithLongLong:bufferq];

  } else if (IS_ENCODE_ULONGLONG(type)) {
    [anInvocation getReturnValue:&bufferQ];
    value = [CMLargeInteger integerWithUnsignedLongLong:bufferQ sign:YES];

  } else if (IS_ENCODE_FLOAT(type) || IS_ENCODE_DOUBLE(type)) {
    [anInvocation getReturnValue:&bufferd];
    value = [CMFloat floatWithDouble:bufferd];

  } else if (IS_ENCODE_CHARP(type)) {
    buffercp = malloc(sizeof(char) * (length+1));
    [anInvocation getReturnValue:&buffercp];
    value = [NSString stringWithCString:buffercp];

  } else if (IS_ENCODE_ID(type)) {
    [anInvocation getReturnValue:&value];

  } else if (IS_ENCODE_CLASS(type)) {
    [anInvocation getReturnValue:&value];

  } else if (IS_ENCODE_SEL(type)) {
    [anInvocation getReturnValue:&sel];
    if (sel) value = [CMSelector selectorWithSelector:sel];

  } else if (IS_ENCODE_VOID(type)) {
    // ignore (= nil)

  } else if (IS_ENCODE_RECT(type)) {
    [anInvocation getReturnValue:&bufferRect];
    value = [CMRect structWithStruct:&bufferRect];

  } else if (IS_ENCODE_RANGE(type)) {
    [anInvocation getReturnValue:&bufferRange];
    value = [CMRange structWithStruct:&bufferRange];

  } else if (IS_ENCODE_SIZE(type)) {
    [anInvocation getReturnValue:&bufferSize];
    value = [CMSize structWithStruct:&bufferSize];

  } else if (IS_ENCODE_POINT(type)) {
    [anInvocation getReturnValue:&bufferPoint];
    value = [CMPoint structWithStruct:&bufferPoint];

  } else {
    [CMException raiseReturnTypeExceptionWithType:type
                 object:[anInvocation target]
                 selector:[anInvocation selector]];
  }

  if (!value) value = [CMNil defaultNil];

  return value;
}

@end



@implementation NSObject (ObjCTypeConverting)

+ (const char *)objCType 
{
  return @encode(id);
}

+ (BOOL)isValidType:(const char *)objCType
{
  return (strcmp([self objCType], objCType) == 0);
}

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_ID(objCType))
    return [self objCValue];
  return nil;
}

- (const void *)objCValue
{
  static id obj;
  obj = self;
  return &obj;
}

@end
