#import <Cocoa/Cocoa.h>

#define IS_ENCODE_CHAR(type)      (strcmp((type), @encode(char)) == 0)
#define IS_ENCODE_UCHAR(type)     (strcmp((type), @encode(unsigned char)) == 0)
#define IS_ENCODE_SHORT(type)     (strcmp((type), @encode(short)) == 0)
#define IS_ENCODE_USHORT(type)    (strcmp((type), @encode(unsigned short)) == 0)
#define IS_ENCODE_INT(type)       (strcmp((type), @encode(int)) == 0)
#define IS_ENCODE_UINT(type)      (strcmp((type), @encode(unsigned int)) == 0)
#define IS_ENCODE_LONG(type)      (strcmp((type), @encode(long)) == 0)
#define IS_ENCODE_ULONG(type)     (strcmp((type), @encode(unsigned long)) == 0)
#define IS_ENCODE_LONGLONG(type)  (strcmp((type), @encode(long long)) == 0)
#define IS_ENCODE_ULONGLONG(type) (strcmp((type), @encode(unsigned long long)) == 0)
#define IS_ENCODE_FLOAT(type)     (strcmp((type), @encode(float)) == 0)
#define IS_ENCODE_DOUBLE(type)    (strcmp((type), @encode(double)) == 0)
#define IS_ENCODE_ID(type)        (strcmp((type), @encode(id)) == 0)
#define IS_ENCODE_IDP(type)       (strcmp((type), @encode(id *)) == 0)
#define IS_ENCODE_CLASS(type)     (strcmp((type), @encode(Class)) == 0)
#define IS_ENCODE_SEL(type)       (strcmp((type), @encode(SEL)) == 0)
#define IS_ENCODE_RECT(type)      (strcmp((type), @encode(NSRect)) == 0)
#define IS_ENCODE_RANGE(type)     (strcmp((type), @encode(NSRange)) == 0)
#define IS_ENCODE_SIZE(type)      (strcmp((type), @encode(NSSize)) == 0)
#define IS_ENCODE_POINT(type)     (strcmp((type), @encode(NSPoint)) == 0)
#define IS_ENCODE_CHARP(type) \
  ((strcmp((type), @encode(char *)) == 0) || \
   (strcmp((type), @encode(const char *)) == 0))
#define IS_ENCODE_VOID(type) \
  ((strcmp((type), @encode(void)) == 0) || \
   (strcmp((type), "Vv") == 0))
#define IS_ENCODE_VOIDP(type) \
  ((strcmp((type), @encode(void *)) == 0) || \
   (strcmp((type), "r^v") == 0))

@interface CMObjCTypeConverter : NSObject {

}


// invocation$B$NLa$jCM$r%*%V%8%'%/%H$KJQ49(B
+ (id)returnValueWithInvocation:(NSInvocation *)anInvocation;

@end



@interface NSObject (ObjCTypeConverting)

// C$B$N%G!<%?7?$X$NJQ49(B
+ (const char *)objCType;
+ (BOOL)isValidType:(const char *)objCType;
- (const void *)objCValueWithType:(const char *)objCType;
- (const void *)objCValue;

@end
