#import "CMObjCMethod.h"
#import "CMMethodProxy.h"
#import "CMException.h"
#import "CMClass.h"
#import <objc/objc-runtime.h>


@implementation CMObjCMethod

+ (id)deallocMethod
{
  return [self methodWithName:@"dealloc"
               selector:@selector(_dealloc)
               forObject:[CMMethodProxy defaultMethodProxy]];
}

+ (id)valueForKeyMethod
{
  return [self methodWithName:@"valueForKey:"
               selector:@selector(_valueForKey:)
               forObject:[CMMethodProxy defaultMethodProxy]];
}

+ (id)setValueForKeyMethod
{
  return [self methodWithName:@"setValue:forKey:"
               selector:@selector(_setValue:forKey:)
               forObject:[CMMethodProxy defaultMethodProxy]];
}

- (struct objc_method *)objCMethod
{
  struct objc_method *objc_method;
  Class class;
  Method superMethod, orgMethod;
  NSMethodSignature *sig;

  objc_method = malloc(sizeof(struct objc_method));
  objc_method->method_name = selector;
  class = [metaClass objCClass];

  // override method
  if ([class instancesRespondToSelector:methodSelector]) {
    superMethod = class_getInstanceMethod(class, selector);
    sig = [class instanceMethodSignatureForSelector:selector];
    objc_method->method_types = superMethod->method_types;
    objc_method->method_imp = method;

  // new method
  } else {
    superMethod = class_getInstanceMethod(class, methodSelector);
    objc_method->method_types = superMethod->method_types;
    objc_method->method_imp = method;
  }

  return objc_method;
}

@end
