#import "common.h"
#import "CMNumber.h"
#import "CMSmallInteger.h"
#import "CMLargeInteger.h"
#import "CMFloat.h"
#import "CMBlock.h"
#import "CMContext.h"
#import <ctype.h>


@implementation CMNumber

+ (id)numberWithString:(NSString *)aString
{
  NSRange range = [aString rangeOfString:@"."];
  if (range.length == 0)
    return [CMInteger integerWithCString:[aString cString] base:-1 check:YES];
  else
    return [CMFloat floatWithString:aString];
}

+ (id)numberWithLong:(long)aValue
{
  if (FIXABLE(aValue)) return PLNG2SINT(aValue);
  return PLNG2LINT(aValue);
}

- (SEL)selectorWithPrefix:(NSString *)prefix forClass:(Class)aClass
{
  NSString *className, *methodName;
  className = NSStringFromClass(aClass);
  methodName = [NSString stringWithFormat:@"%@%@:", prefix, className];
  return NSSelectorFromString(methodName);
}

- (NSComparisonResult)compare:(id)anObject
{
  SEL selector;
  NSInvocation *inv;
  NSMethodSignature *sig;
  int result;

  selector = [self selectorWithPrefix:@"compare" forClass:[anObject class]];
  sig = [self methodSignatureForSelector:selector];
  inv = [NSInvocation invocationWithMethodSignature:sig];
  [inv setSelector:selector];
  [inv setArgument:&anObject atIndex:2];
  [inv invokeWithTarget:self];
  [inv getReturnValue:&result];
  return result;
}

- (id)dispatchSelector:(SEL)aSelector withObject:(id)anObject
{
  NSString *prefix;
  NSRange range;
  SEL selector;

  prefix = NSStringFromSelector(aSelector);
  range = NSMakeRange(0, [prefix length] - 1);
  prefix = [prefix substringWithRange:range];
  selector = [self selectorWithPrefix:prefix forClass:[anObject class]];
  return [self performSelector:selector withObject:anObject];
}

- (id)objectByAdding:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)objectBySubtracting:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)objectByMultiplyingBy:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)objectByDividingBy:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)moduloOfDividedBy:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)remainderOfDividedBy:(id)anObject
{
  id modulo = [self moduloOfDividedBy:anObject];

  if (![modulo isEqual:PINT2SINT(0)] &&
      (([self isGreaterThan:PINT2SINT(0)] &&
        [anObject isLessThan:PINT2SINT(0)]) ||
       ([self isLessThan:PINT2SINT(0)] &&
        [anObject isGreaterThan:PINT2SINT(0)]))) {
    return [modulo objectBySubtracting:anObject];
  }
  return modulo;
}

- (id)objectByRaisingToPower:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)objectByShiftingRight:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)objectByShiftingLeft:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)and:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)or:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)xor:(id)anObject
{
  return [self dispatchSelector:_cmd withObject:anObject];
}

- (id)negated
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (BOOL)isZero
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (NSDecimalNumber *)decimalNumber
{
  return [NSDecimalNumber decimalNumberWithString:[self description]];
}

- (int)intValue
{
  long num = [self longValue];
  [[self class] validateRangeOfIntValueWithLongValue:num];
  return num;
}

+ (void)validateRangeOfIntValueWithLongValue:(long)value
{
  NSString *s;
  if (value < INT_MIN) {
    s = @"small";
  } else if (value > INT_MAX) {
    s = @"big";
  } else {
    return;
  }
  [NSException raise:NSRangeException
               format:@"integer %ld too %@ to convert to `int'", value, s];
}

- (CMInteger *)integer
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (CMFloat *)float
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (long)longValue
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (double)doubleValue
{
  [self doesNotRecognizeSelector:_cmd];
  return nil;
}

- (void)to:(CMNumber *)stop do:(CMBlock *)aBlock
{
  [self to:stop by:PINT2SINT(1) do:aBlock];
}

- (void)to:(CMNumber *)stop by:(CMNumber *)step do:(CMBlock *)aBlock
{
  CMNumber *index = self;
  while ([index compare:stop] != NSOrderedDescending) {
    [aBlock value:index];
    if (![[CMContext sender] continuesVisitation])
      break;
    index = [index objectByAdding:step];
  }
}

- (void)timesRepeat:(CMBlock *)aBlock
{
  double index = [self doubleValue];
  while (index > 0) {
    [aBlock value];
    if (![[CMContext sender] continuesVisitation])
      break;
    index = index - 1;
  }
}

- (BOOL)isEqualTo:(id)anObject
{
  return [self compare:anObject] == NSOrderedSame;
}

@end
