#import <Cocoa/Cocoa.h>
#import <limits.h>

#define SIZEOF_INT 4
#define SIZEOF_SHORT 2
#define SIZEOF_LONG 4
#define SIZEOF_LONG_LONG 8
#define SIZEOF___INT64 0
#define SIZEOF_OFF_T 8
#define SIZEOF_VOIDP 4
#define SIZEOF_FLOAT 4
#define SIZEOF_DOUBLE 8

#if SIZEOF_LONG_LONG > 0
# define LONG_LONG long long
#elif SIZEOF___INT64 > 0
# define HAVE_LONG_LONG 1
# define LONG_LONG __int64
# undef SIZEOF_LONG_LONG
# define SIZEOF_LONG_LONG SIZEOF___INT64
#endif

#if SIZEOF_INT*2 <= SIZEOF_LONG_LONG
# define BDIGIT unsigned int
# define SIZEOF_BDIGITS SIZEOF_INT
# define BDIGIT_DBL unsigned LONG_LONG
# define BDIGIT_DBL_SIGNED LONG_LONG
#elif SIZEOF_INT*2 <= SIZEOF_LONG
# define BDIGIT unsigned int
# define SIZEOF_BDIGITS SIZEOF_INT
# define BDIGIT_DBL unsigned long
# define BDIGIT_DBL_SIGNED long
#elif SIZEOF_SHORT*2 <= SIZEOF_LONG
# define BDIGIT unsigned short
# define SIZEOF_BDIGITS SIZEOF_SHORT
# define BDIGIT_DBL unsigned long
# define BDIGIT_DBL_SIGNED long
#else
# define BDIGIT unsigned short
# define SIZEOF_BDIGITS (SIZEOF_LONG/2)
# define BDIGIT_DBL unsigned long
# define BDIGIT_DBL_SIGNED long
#endif

#define RSHIFT(x,y) ((x)>>(int)y)
//#define BDIGITS(x) ((BDIGIT*)RBIGNUM(x)->digits)
#define BDIGITS(x) ((BDIGIT*)[(x) digits])
#define BITSPERDIG (SIZEOF_BDIGITS*CHAR_BIT)
#define BIGRAD ((BDIGIT_DBL)1 << BITSPERDIG)
#define DIGSPERLONG ((unsigned int)(SIZEOF_LONG/SIZEOF_BDIGITS))
#if HAVE_LONG_LONG
# define DIGSPERLL ((unsigned int)(SIZEOF_LONG_LONG/SIZEOF_BDIGITS))
#endif
#define BIGUP(x) ((BDIGIT_DBL)(x) << BITSPERDIG)
#define BIGDN(x) RSHIFT(x,BITSPERDIG)
#define BIGLO(x) ((BDIGIT)((x) & (BIGRAD-1)))
#define BDIGMAX ((BDIGIT)-1)

#define FIXNUM_FLAG 0x01
#define FIXNUM_P(f) (((long)(f))&FIXNUM_FLAG)
#define FIXNUM_MAX (LONG_MAX>>1)
#define FIXNUM_MIN RSHIFT((long)LONG_MIN,1)
#define POSFIXABLE(f) ((f) <= FIXNUM_MAX)
#define NEGFIXABLE(f) ((f) >= FIXNUM_MIN)
#define FIXABLE(f) (POSFIXABLE(f) && NEGFIXABLE(f))
#define BITSPERDIG (SIZEOF_BDIGITS*CHAR_BIT)
#define ISSPACE(c) (isascii(c) && isspace(c))

#define REALLOC_N(var,type,n) (var)=(type*)realloc((char*)(var),sizeof(type)*(n))

@class CMInteger, CMBlock, CMFloat;

@interface CMNumber : NSObject {

}

+ (id)numberWithString:(NSString *)aString;
+ (id)numberWithLong:(long)aValue;

- (SEL)selectorWithPrefix:(NSString *)prefix forClass:(Class)aClass;
- (NSComparisonResult)compare:(id)anObject;   // <=>
- (id)objectByAdding:(id)anObject;            // +
- (id)objectBySubtracting:(id)anObject;       // -
- (id)objectByMultiplyingBy:(id)anObject;     // *
- (id)objectByDividingBy:(id)anObject;        // /
- (id)moduloOfDividedBy:(id)anObject;         // %
- (id)remainderOfDividedBy:(id)anObject;      // %%
- (id)objectByRaisingToPower:(id)anObject;    // **
- (id)objectByShiftingRight:(id)anObject;     // >>
- (id)objectByShiftingLeft:(id)anObject;      // <<
- (id)and:(id)anObject;                       // &
- (id)or:(id)anObject;                        // |
- (id)xor:(id)anObject;                       // ^

- (id)negated;
- (BOOL)isZero;
- (NSDecimalNumber *)decimalNumber;
- (CMInteger *)integer;
- (CMFloat *)float;
- (int)intValue;
- (long)longValue;
- (double)doubleValue;
+ (void)validateRangeOfIntValueWithLongValue:(long)value;

- (void)to:(CMNumber *)stop do:(CMBlock *)aBlock;
- (void)to:(CMNumber *)stop by:(CMNumber *)step do:(CMBlock *)aBlock;
- (void)timesRepeat:(CMBlock *)aBlock;

@end
