#import <Cocoa/Cocoa.h>

@class CMContext, CMClassNode, CMVariableNode, CMMethodNode,
  CMMessageNode, CMSubstituteNode, CMExpressionNode, CMVariableNode,
  CMVariableDeclarationNode, CMReturnNode, CMStringNode,
  CMArrayNode, CMDictionaryNode, CMDigitNode, CMBlockNode, CMSelectorNode,
  CMRegularExpressionNode, CMBlockArgumentsNode, CMKeyPathNode,
  CMKeyValueCodingNode;


@protocol CMNodeVisitor

- (void)visitClassNode:(CMClassNode *)aNode;
- (void)visitVariableNode:(CMVariableNode *)aNode;
- (void)visitVariableDeclarationNode:(CMVariableDeclarationNode *)aNode;
- (void)visitMethodNode:(CMMethodNode *)aNode;
- (void)visitMessageNode:(CMMessageNode *)aNode;
- (void)visitSubstituteNode:(CMSubstituteNode *)aNode;
- (void)visitReturnNode:(CMReturnNode *)aNode;
- (void)visitBlockNode:(CMBlockNode *)aNode;
- (void)visitBlockArgumentsNode:(CMBlockArgumentsNode *)aNode;
- (void)visitStringNode:(CMStringNode *)aNode;
- (void)visitArrayNode:(CMArrayNode *)aNode;
- (void)visitDictionaryNode:(CMDictionaryNode *)aNode;
- (void)visitDigitNode:(CMDigitNode *)aNode;
- (void)visitExpressionNode:(CMExpressionNode *)aNode;
- (void)visitSelectorNode:(CMSelectorNode *)aNode;
- (void)visitRegularExpressionNode:(CMRegularExpressionNode *)aNode;
- (void)visitKeyPathNode:(CMKeyPathNode *)aNode;
- (void)visitKeyValueCodingNode:(CMKeyValueCodingNode *)aNode;

@end


@interface CMNodeVisitor : NSObject {
    CMContext *context;
}

+ (id)visitorWithContext:(CMContext *)aContext;

- (id)initWithContext:(CMContext *)aContext;
- (void)dealloc;

@end
