#import "common.h"
#import "CMNode.h"
#import "CMNodeVisitor.h"
#import "CMBlockNode.h"
#import "CMClass.h"
#import "CMClassNode.h"
#import "CMMethodNode.h"
#import "CMNil.h"
#import "CMContext.h"
#import <OgreKit/OgreKit.h>

@implementation CMNode

+ (id)node
{
  return [[[self alloc] init] autorelease];
}

+ (id)nodeWithNodes:(CMNode *)aNode, ...
{
  id obj = [[[self alloc] init] autorelease];
  va_list ap;
  CMNode *arg;

  if (aNode) {
    [obj addNode:aNode];
    va_start(ap, aNode);
    while (arg = va_arg(ap, CMNode *)) {
      [obj addNode:arg];
    }
    va_end(ap);
  }

  return obj;
}

- (id)init
{
  [super init];
  nodes = [[NSMutableArray alloc] initWithCapacity:1];
  contents = [[NSMutableString alloc] initWithCapacity:1];
  lineNumber = 0;
  return self;
}

- (void)dealloc
{
  [nodes release];
  [parentNode release];
  [contents release];
  [fileName release];
  [super dealloc];
}

- (NSString *)description
{
  NSString *own = [self ownDescription];
  NSMutableString *desc = [NSMutableString stringWithFormat:@"(%@",
                                           [[self class] nodeName]];
  if (own)
    [desc appendString:[NSString stringWithFormat:@" \"%@\"", own]];

  if ([nodes count] > 0) {
    [desc appendString:@" '("];
    id e = [nodes objectEnumerator];
    id obj;
    NSMutableArray *nodesDesc = [NSMutableArray arrayWithCapacity:[nodes count]];
    while (obj = [e nextObject]) {
      [nodesDesc addObject:[obj description]];
    }
    [desc appendString:[nodesDesc componentsJoinedByString:@" "]];
    [desc appendString:@"))"];
  }
  [desc appendString:@")"];
  return desc;
}

- (NSString *)ownDescription
{
  return nil;
}

+ (NSString *)nodeName
{
  OGRegularExpression *regexp;
  OGRegularExpressionMatch *match;

  regexp = [OGRegularExpression regularExpressionWithString:@"CM(.*?)Node"];
  match = [regexp matchInString:NSStringFromClass(self)];
  return [[match substringAtIndex:1] lowercaseString];
}

- (NSString *)contents { return contents; }
- (void)setContents:(NSString *)aString { [contents setString:aString]; }
- (void)appendContents:(NSString *)aString { [contents appendString:aString]; }

- (void)addNode:(CMNode *)aNode
{
  [nodes addObject:aNode];
  [aNode setParentNode:self];
}

- (void)addNodesInArray:(NSArray *)anArray
{
  id obj, e = [anArray objectEnumerator];
  while (obj = [e nextObject]) {
    [self addNode:obj];
  }
}

- (NSMutableArray *)nodes { return nodes; }

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  [self nodesAcceptVisitor:aVisitor];
}

- (void)nodesAcceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  id e, node;
  e = [nodes objectEnumerator];
  while (node = [e nextObject]) {
    [node acceptVisitor:aVisitor];
  }
}

- (CMNode *)parentNode{ return parentNode; }

- (void)setParentNode:(CMNode *)aNode
{
  [aNode retain];
  [parentNode release];
  parentNode = aNode;
}

- (CMNode *)rootNode
{
  CMNode *parent;
  CMNode *current = self;
    
  while (parent = [current parentNode]) {
    current = parent;
  }
  return current;
}

- (CMNode *)firstNode
{
  return (CMNode *)[nodes objectAtIndex:0];
}

- (CMNode *)lastNode
{
  return (CMNode *)[nodes lastObject];
}

- (CMMethodNode *)methodNode
{
  id parent, current = self;

  if ([self isKindOfClass:[CMMethodNode class]])
    return (CMMethodNode *)self;

  while (parent = [current parentNode]) {
    if ([parent isKindOfClass:[CMMethodNode class]])
      return parent;
    else
      current = parent;
  }
  return nil;
}

- (CMNode *)variableStoreNode
{
  id parent, current = self;

  if ([self isKindOfClass:[CMMethodNode class]] ||
      [self isKindOfClass:[CMBlockNode class]])
    return self;

  while (parent = [current parentNode]) {
    if ([parent isKindOfClass:[CMMethodNode class]] ||
        [parent isKindOfClass:[CMBlockNode class]])
      return parent;
    else
      current = parent;
  }
  return nil;
}

- (CMVariableStore *)variableStore
{
  return [[self variableStoreNode] variableStore];
}

- (CMClassNode *)classNode
{
  id parent, current = self;

  while (parent = [current parentNode]) {
    if ([parent isKindOfClass:[CMClassNode class]])
      return parent;
    else
      current = parent;
  }
  return nil;
}

- (CMClass *)classWrapper
{
  return [CMClass classNamed:[[self classNode] name]];
}

- (int)lineNumber
{
  if (lineNumber == 0)
    return [parentNode lineNumber];
  else
    return lineNumber;
}

- (void)setLineNumber:(int)number
{
  lineNumber = number;
}

- (NSString *)fileName
{
  if (fileName)
    return fileName;
  else
    return [parentNode fileName];
}

- (void)setFileName:(NSString *)aName
{
  [fileName release];
  fileName = [[NSString alloc] initWithString:aName];
}

- (NSMutableDictionary *)userInfo
{
  NSMutableDictionary *info = [NSMutableDictionary dictionaryWithCapacity:1];
  [info setObject:[self fileName] forKey:CMFileNameKey];
  [info setObject:[NSNumber numberWithInt:[self lineNumber]] forKey:CMLineNumberKey];
  [info setObject:[NSMutableArray arrayWithCapacity:1] forKey:CMExceptionsKey];
  return info;
}

- (NSMutableDictionary *)userInfoWithMethodNode:(CMMethodNode *)aNode
{
  NSMutableDictionary *info = [self userInfo];
  if (aNode)
    [info setObject:[[aNode metaMethod] description] forKey:CMMethodNameKey];
  return info;
}

@end
