#import <Cocoa/Cocoa.h>
#import "CMNodeVisitor.h"

@class CMClass, CMClassNode, CMMethodNode, CMVariableStore;

@protocol CMVisitee
- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor;
@end

@interface CMNode : NSObject <CMVisitee> {
    NSMutableArray *nodes;
    CMNode *parentNode;
    NSMutableString *contents;
    NSString *fileName;
    int lineNumber;
}

+ (id)node;
+ (id)nodeWithNodes:(CMNode *)aNode, ...;

- (id)init;
- (void)dealloc;
- (NSString *)description;
- (NSString *)ownDescription;
+ (NSString *)nodeName;

- (NSString *)contents;
- (void)setContents:(NSString *)aString;
- (void)appendContents:(NSString *)aString;

- (NSMutableArray *)nodes;
- (void)addNode:(CMNode *)aNode;
- (void)addNodesInArray:(NSArray *)anArray;
- (CMNode *)parentNode;
- (void)setParentNode:(CMNode *)aNode;
- (CMNode *)rootNode;
- (CMNode *)firstNode;
- (CMNode *)lastNode;

- (CMClassNode *)classNode;

// metaClass
- (CMClass *)classWrapper;
//- (CMClass *)metaClass;
- (CMClassNode *)classNode;
- (CMMethodNode *)methodNode;
- (CMNode *)variableStoreNode;
- (CMVariableStore *)variableStore;

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor;
- (void)nodesAcceptVisitor:(id <CMNodeVisitor>)aVisitor;

- (NSString *)fileName;
- (void)setFileName:(NSString *)aName;
- (int)lineNumber;
- (void)setLineNumber:(int)number;

- (NSMutableDictionary *)userInfo;
- (NSMutableDictionary *)userInfoWithMethodNode:(CMMethodNode *)aNode;

@end
