#import "common.h"
#import "CMNil.h"
#import "CMBlock.h"

static id defaultNil = nil;

@implementation CMNil

+ (id)defaultNil
{
  if (!defaultNil) defaultNil = [self new];
  return defaultNil;
}

+ (BOOL)scriptRespondsToSelector:(SEL)aSelector
{
  return (aSelector == @selector(isNil)) ||
    (aSelector == @selector(isNil)) ||
    (aSelector == @selector(ifNil)) ||
    (aSelector == @selector(ifNil:ifNotNil:)) ||
    (aSelector == @selector(ifNotNil)) ||
    (aSelector == @selector(ifNotNil:ifNil:)) ||
    (aSelector == @selector(ifNotNilDo:));
}

- (BOOL)isNil
 {
   return YES;
}

- (id)ifNil:(CMBlock *)aBlock
{
  return [aBlock value];
}

- (id)ifNil:(CMBlock *)aBlock1 ifNotNil:(CMBlock *)aBlock2
{
  return [aBlock1 value];
}

- (id)ifNotNil:(CMBlock *)aBlock
{
  return nil;
}

- (id)ifNotNil:(CMBlock *)aBlock1 ifNil:(CMBlock *)aBlock2
{
  return [aBlock2 value];
}

- (id)ifNotNilDo:(CMBlock *)aBlock
{
  return nil;
}

- (void)forwardInvocation:(NSInvocation *)anInvocation {}

- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector
{
  if ([super respondsToSelector:aSelector])
    return [super methodSignatureForSelector:aSelector];
  else
    // dummy signature
    return [super methodSignatureForSelector:@selector(self)];
}

@end


@implementation NSObject (CMNil)

- (BOOL)isNil
{
  return NO;
}

- (id)ifNil:(CMBlock *)aBlock
{
  return nil;
}

- (id)ifNil:(CMBlock *)aBlock1 ifNotNil:(CMBlock *)aBlock2
{
  return [aBlock2 value];
}

- (id)ifNotNil:(CMBlock *)aBlock
{
  return [aBlock value];
}

- (id)ifNotNil:(CMBlock *)aBlock1 ifNil:(CMBlock *)aBlock2
{
  return [aBlock1 value];
}

- (id)ifNotNilDo:(CMBlock *)aBlock
{
  return [aBlock value:self];
}

@end
