#import "common.h"
#import "CMMethodProxy.h"
#import "CMObject.h"
#import "CMClass.h"
#import "CMMethod.h"
#import "CMTrue.h"
#import "CMFalse.h"
#import "CMLargeInteger.h"
#import "CMFloat.h"
#import "CMSelector.h"
#import "CMRect.h"
#import "CMException.h"
#import "CMNil.h"
#import "CMObjCTypeConverter.h"

static id defaultMethodProxy = nil;

@implementation CMMethodProxy

+ (id)defaultMethodProxy
{
  if (!defaultMethodProxy)
    defaultMethodProxy = [[self alloc] init];
  return defaultMethodProxy;
}

+ (id)_objectOfVariable
{
  id wrapper = [CMObject objectForObject:self];
  return [wrapper objectForVariableNamed:NSStringFromSelector(_cmd)];
}

+ (id)_setVariableToObject:(id)anObject
{
  NSString *sel, *var, *first, *other;
  NSRange range;
    
  id wrapper = [CMObject objectForObject:self];
  sel = NSStringFromSelector(_cmd);
  range = NSMakeRange(3, ([sel length] - 4));
  var = [sel substringWithRange:range];
  first = [[var substringToIndex:1] lowercaseString];
  other = [var substringFromIndex:1];
  var = [NSString stringWithFormat:@"%@%@", first, other];
  [wrapper setObject:anObject forVariableNamed:var];

  // if void, self returns.
  return nil;
}

- (id)_objectOfVariable
{
  id wrapper = [CMObject objectForObject:self];
  return [wrapper objectForVariableNamed:NSStringFromSelector(_cmd)];
}

- (id)_setVariableToObject:(id)anObject
{
  NSString *sel, *var, *first, *other;
  NSRange range;
    
  id wrapper = [CMObject objectForObject:self];
  sel = NSStringFromSelector(_cmd);
  range = NSMakeRange(3, ([sel length] - 4));
  var = [sel substringWithRange:range];
  first = [[var substringToIndex:1] lowercaseString];
  other = [var substringFromIndex:1];
  var = [NSString stringWithFormat:@"%@%@", first, other];
  [wrapper setObject:anObject forVariableNamed:var];

  // if void, self returns.
  return nil;
}

+ (id)_invoke
{
  return [CMMethod performSelector:_cmd forObject:self withObjects:nil];
}

+ (id)_invokeWithObject:(id)anObject
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject, nil];
}


+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3 :(id)anObject4
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
                       :(id)anObject7
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, anObject7, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
                       :(id)anObject7 :(id)anObject8
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, anObject7, anObject8, nil];
}

+ (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
                       :(id)anObject7 :(id)anObject8 :(id)anObject9
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, anObject7, anObject8, anObject9, nil];
}

- (id)_invoke
{
  return [CMMethod performSelector:_cmd forObject:self withObjects:nil];
}

- (id)_invokeWithObject:(id)anObject
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3 :(id)anObject4
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
                       :(id)anObject7
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, anObject7, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
                       :(id)anObject7 :(id)anObject8
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, anObject7, anObject8, nil];
}

- (id)_invokeWithObject:(id)anObject1 :(id)anObject2 :(id)anObject3
                       :(id)anObject4 :(id)anObject5 :(id)anObject6
                       :(id)anObject7 :(id)anObject8 :(id)anObject9
{
  return [CMMethod performSelector:_cmd
                   forObject:self
                   withObjects:anObject1, anObject2, anObject3, anObject4,
                   anObject5, anObject6, anObject7, anObject8, anObject9, nil];
}

- (void)_dealloc
{
  LOG(@"* dealloc %@", [self description]);
  [CMObject removeObject:self];
  [super dealloc];
}

- (id)_valueForKey:(NSString *)key
{
  LOG(@"* valueForKey: %@", key);
  if ([[CMClass classForObject:self] instanceMethodNamed:key])
    return [self performSelector:NSSelectorFromString(key)];
  else
    return [super valueForKey:key];
}

- (void)_setValue:(id)value forKey:(NSString *)key
{
  LOG(@"* setValue: %@ forKey: %@", [value description], key);
  NSString *setter = [CMMethod setterNameForKey:key];
  if ([[CMClass classForObject:self] instanceMethodNamed:setter])
    [self performSelector:NSSelectorFromString(setter) withObject:value];
  else
    [super setValue:value forKey:key];
}


// I[o[Ch\bhĂԂƁÅ֐Ă΂B
// XNvg̃\bhĂяoB
// 1. methodtype擾
// 2. eo
// 3. eIuWFNgɕϊ
//    XNvgĂ΂Ƃ͂łɑݕϊĂ
// 4. [CMMethod perform...]Ń\bhĂяo

id _forwardMessage(id self, SEL _cmd, ...)
{
  va_list ap;
  va_start(ap, _cmd);
  return _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return nil;
}

int _intForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);

  if ([value isMemberOfClass:[CMTrue class]])
    return YES;
  else if ([value isMemberOfClass:[CMFalse class]])
    return NO;
  else
    return [value intValue];
}

unsigned int _unsignedIntForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value unsignedIntValue];
}

long _longForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value longValue];
}

unsigned long _unsignedLongForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value unsignedLongValue];
}

long long _longLongForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value longLongValue];
}

unsigned long long _unsignedLongLongForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value unsignedLongLongValue];
}

double _doubleForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value doubleValue];
}

char *_charPointerforwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return (char *)[value cString];
}

SEL _selForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value selector];
}

NSRange _rangeForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value rangeValue];
}

NSRect _rectForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value rectValue];
}

NSSize _sizeForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value sizeValue];
}

NSPoint _pointForwardMessage(id self, SEL _cmd, ...)
{
  id value;
  va_list ap;
  va_start(ap, _cmd);
  value = _forwardMessageWithArguments(self, _cmd, ap);
  va_end(ap);
  return [value pointValue];
}

id _forwardMessageWithArguments(id self, SEL _cmd, va_list ap)
{
  int i;
  int argi;
  unsigned int num, argI;
  char *argcp;
  long argl;
  unsigned long argL;
  long long argq;
  unsigned long long argQ;
  double argd;
  SEL argSEL;
  NSRect argRect;
  NSRange argRange;
  NSSize argSize;
  NSPoint argPoint;
  const char *type;
  id arg = nil;
  NSMethodSignature *sig;
  NSMutableArray *arguments;

  sig = [self methodSignatureForSelector:_cmd];
  num = [sig numberOfArguments];
  arguments = [NSMutableArray arrayWithCapacity:num];

  // ready arguments, convert primitive type or id to id
  if (num > 2) {
    for (i = 2; i < num; i++) {
      type = [sig getArgumentTypeAtIndex:i];
      if (IS_ENCODE_ID(type)) {
        arg = va_arg(ap, id);

      } else if (IS_ENCODE_CHARP(type)) {
        argcp = va_arg(ap, char *);
        arg = [NSString stringWithCString:argcp];

      } else if (IS_ENCODE_CHAR(type) || IS_ENCODE_UCHAR(type) ||
                 IS_ENCODE_SHORT(type) || IS_ENCODE_USHORT(type) ||
                 IS_ENCODE_INT(type)) {
        argi = va_arg(ap, int);
        arg = PLNG2SINT(argi);

      } else if (IS_ENCODE_UINT(type)) {
        argI = va_arg(ap, unsigned int);
        arg = PLNG2SINT(argI);

      } else if (IS_ENCODE_LONG(type)) {
        argl = va_arg(ap, long);
        arg = PLNG2SINT(argl);

      } else if (IS_ENCODE_ULONG(type)) {
        argL = va_arg(ap, unsigned long);
        arg = [CMLargeInteger
                integerWithUnsignedLongLong:(unsigned long long)argL
                sign:YES];

      } else if (IS_ENCODE_LONGLONG(type)) {
        argq = va_arg(ap, long long);
        arg = [CMLargeInteger integerWithLongLong:argq];

      } else if (IS_ENCODE_ULONGLONG(type)) {
        argQ = va_arg(ap, unsigned long long);
        arg = [CMLargeInteger integerWithUnsignedLongLong:argQ sign:YES];

      } else if (IS_ENCODE_FLOAT(type) || IS_ENCODE_DOUBLE(type)) {
        argd = va_arg(ap, double);
        arg = [CMFloat floatWithDouble:argd];

      } else if (IS_ENCODE_CLASS(type)) {
        arg = va_arg(ap, Class);

      } else if (IS_ENCODE_SEL(type)) {
        argSEL = va_arg(ap, SEL);
        arg = [CMSelector selectorWithSelector:argSEL];

      } else if (IS_ENCODE_RECT(type)) {
        argRect = va_arg(ap, NSRect);
        arg = [CMRect structWithStruct:&argRect];

      } else if (IS_ENCODE_RANGE(type)) {
        argRange = va_arg(ap, NSRange);
        arg = [CMRect structWithStruct:&argRange];

      } else if (IS_ENCODE_SIZE(type)) {
        argSize = va_arg(ap, NSSize);
        arg = [CMRect structWithStruct:&argSize];

      } else if (IS_ENCODE_POINT(type)) {
        argPoint = va_arg(ap, NSPoint);
        arg = [CMRect structWithStruct:&argPoint];

      } else if (IS_ENCODE_VOID(type)) {
        arg = nil;

      } else {
        [CMException raiseArgumentTypeExceptionWithType:type
                     atIndex:i
                     object:self
                     selector:_cmd];
      }

      if (!arg) arg = [CMNil defaultNil];
      [arguments addObject:arg];
    }
  }

  // invoke method
  return [CMMethod performSelector:_cmd forObject:self withArguments:arguments];
}

+ (IMP)methodForEncodeType:(const char *)type
{
  if (IS_ENCODE_CHAR(type) || IS_ENCODE_UCHAR(type) ||
      IS_ENCODE_SHORT(type) || IS_ENCODE_USHORT(type) || IS_ENCODE_INT(type))
    return (IMP)_intForwardMessage;

  else if (IS_ENCODE_UINT(type))
    return (IMP)_unsignedIntForwardMessage;

  else if (IS_ENCODE_LONG(type))
    return (IMP)_longForwardMessage;

  else if (IS_ENCODE_ULONG(type))
    return (IMP)_unsignedLongForwardMessage;

  else if (IS_ENCODE_LONGLONG(type))
    return (IMP)_longLongForwardMessage;

  else if (IS_ENCODE_ULONGLONG(type))
    return (IMP)_unsignedLongLongForwardMessage;

  else if (IS_ENCODE_FLOAT(type) || IS_ENCODE_DOUBLE(type))
    return (IMP)_doubleForwardMessage;

  else if (IS_ENCODE_ID(type) || IS_ENCODE_CLASS(type) || IS_ENCODE_VOID(type))
    return (IMP)_forwardMessage;

  else if (IS_ENCODE_SEL(type))
    return (IMP)_selForwardMessage;

  else if (IS_ENCODE_RANGE(type))
    return (IMP)_rangeForwardMessage;

  else if (IS_ENCODE_RECT(type))
    return (IMP)_rectForwardMessage;

  else if (IS_ENCODE_SIZE(type))
    return (IMP)_sizeForwardMessage;

  else if (IS_ENCODE_POINT(type))
    return (IMP)_pointForwardMessage;

  else
    return nil;
}

@end
