#import "common.h"
#import "CMMethodNode.h"
#import "CMClass.h"
#import "CMMethod.h"
#import "CMClassNode.h"

@implementation CMMethodNode

+ (id)nodeWithOperatorString:(NSString *)aString
{
  id node = [[[self alloc] init] autorelease];
  if ([aString isEqualToString:@"+"]) {
    [node setIsClassMethod:YES];
  } else if ([aString isEqualToString:@"-"]) {
    [node setIsInstanceMethod:YES];
  } else {
    // error
  }
  return node;
}

- (id)init
{
  [super init];
  name = [[NSMutableString alloc] init];
  argumentNames = [[NSMutableArray alloc] initWithCapacity:1];
  isNamed = NO;
  return self;
}

- (void)dealloc
{
  [name release];
  [argumentNames release];
  [comment release];
  [sourceCode release];
  [super dealloc];
}

- (NSString *)ownDescription;
{
  return name;
}

- (NSString *)name { return name; }

- (void)appendName:(NSString *)aName
{
  [name appendString:aName];
}

- (BOOL)isNamed { return isNamed; }
- (void)setIsNamed:(BOOL)flag { isNamed = flag; }
- (NSArray *)argumentNames { return argumentNames; }

- (void)addArgumentName:(NSString *)aName
{
  [argumentNames addObject:aName];
}

- (int)argumentCount
{
  return [argumentNames count];
}

- (BOOL)isClassMethod { return !isInstanceMethod; }
- (void)setIsClassMethod:(BOOL)flag { isInstanceMethod = !flag; }
- (BOOL)isInstanceMethod { return isInstanceMethod; }
- (void)setIsInstanceMethod:(BOOL)flag { isInstanceMethod = flag; }

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitMethodNode");
  [aVisitor visitMethodNode:self];
  LOG(@"<== visitMethodNode");
}

- (CMClass *)metaClass
{
  return [[self classNode] metaClass];
}

- (CMMethod *)metaMethod
{
  if ([self isClassMethod])
    return [[self metaClass] classMethodNamed:name];
  else
    return [[self metaClass] instanceMethodNamed:name];
}

- (NSString *)comment { return comment; }
- (void)setComment:(NSString *)aComment { ASSIGN(comment, aComment); }
- (NSString *)sourceCode { return sourceCode; }
- (void)setSourceCode:(NSString *)aCode { ASSIGN(sourceCode, aCode); }

@end
