#import <Cocoa/Cocoa.h>
#import "CMNode.h"
#import "CMNodeVisitor.h"
#import "CMSourceCode.h"

@class CMClass, CMMethod;

@interface CMMethodNode : CMNode <CMSourceCode> {
    BOOL isInstanceMethod, isNamed;
    NSMutableString *name;
    NSMutableArray *argumentNames;
    NSString *sourceCode, *comment;
}

+ (id)nodeWithOperatorString:(NSString *)aString;

- (id)init;
- (void)dealloc;
- (NSString *)ownDescription;

- (NSString *)name;
- (void)appendName:(NSString *)aName;
- (BOOL)isNamed;
- (void)setIsNamed:(BOOL)flag;
- (NSArray *)argumentNames;
- (void)addArgumentName:(NSString *)aName;
- (int)argumentCount;

- (BOOL)isClassMethod;
- (void)setIsClassMethod:(BOOL)flag;
- (BOOL)isInstanceMethod;
- (void)setIsInstanceMethod:(BOOL)flag;

- (CMClass *)metaClass;
- (CMMethod *)metaMethod;

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor;

- (NSString *)comment;
- (void)setComment:(NSString *)aComment;
- (NSString *)sourceCode;
- (void)setSourceCode:(NSString *)aCode;

@end
