//
//  CMMethodContext.m
//  CocoaMill
//

#import "CMMethodContext.h"
#import "CMMethod.h"
#import "CMContext.h"
#import "CMObject.h"
#import "CMRuntime.h"

@implementation CMMethodContext

- (id)initWithSenedr:(id)aSender
            receiver:(id)aReceiver
              method:(id)aMethod
           arguments:(NSArray *)arguments
{
  [super initWithSender:aSender
         receiver:aReceiver
         method:aMethod
         arguments:arguments];
  int i;
  for (i = 0; i < [aMethod numberOfArguments]; i++) {
    [self setObject:[arguments objectAtIndex:i]
          forNewVariableNamed:[[aMethod argumentNames] objectAtIndex:i]];
  }
  return self;
}

- (void)dealloc
{
  [method release];
  [super dealloc];
}

- (NSString *)description
{
  return [NSString stringWithFormat:@"<%@ %@>", [self class], [method description]];
}

- (CMVariable *)variableNamed:(NSString *)aName
{
  CMVariable *var;
  id obj;

  // local variable
  if (var = [super variableNamed:aName]) return var;

  // instance variable
  obj = [CMObject objectForObject:receiver];
  if (var = [obj variableNamed:aName]) return var;

  // class variable
  obj = [CMObject objectForObject:[receiver class]];
  if (var = [obj variableNamed:aName]) return var;

  // global variable
  var = [[CMRuntime defaultRuntime] variableNamed:aName];
  return var;
}

@end
