#import <Cocoa/Cocoa.h>
#import <objc/objc-runtime.h>
#import "CMSourceCode.h"

@class CMMethodNode, CMClass, CMObject;

@interface CMMethod : NSObject <CMSourceCode> {
    NSString *name;
    SEL selector, methodSelector;
    IMP method;
    CMMethodNode *node;
    CMClass *metaClass;
}

+ (id)methodWithName:(NSString *)aName
            selector:(SEL)aSelector
           forObject:(id)anObject;
+ (id)methodWithNode:(CMMethodNode *)aNode;

- (id)initWithName:(NSString *)aName;
- (id)initWithNode:(CMMethodNode *)aNode;
- (id)initWithName:(NSString *)aName
          selector:(SEL)aSelector
         forObject:(id)anObject;
- (void)dealloc;

+ (id)performSelector:(SEL)aSelector
            forObject:(id)anObject
          withObjects:(id)anArgument, ...;
+ (id)performSelector:(SEL)aSelector
            forObject:(id)anObject
        withArguments:(NSArray *)arguments;

- (NSString *)name;
- (SEL)selector;
- (SEL)methodSelector;
- (IMP)method;
- (struct objc_method *)objCMethod;
- (CMMethodNode *)node;
- (CMClass *)metaClass;
- (void)setMetaClass:(CMClass *)aClass;
- (SEL)invokeSelectorForArgumentCount:(int)count;
- (NSArray *)argumentNames;
- (unsigned)numberOfArguments;
- (NSString *)comment;
- (NSString *)sourceCode;

+ (SEL)selectorForString:(NSString *)aString;
+ (NSDictionary *)operatorDictionary;
+ (SEL)operatorSelectorForString:(NSString *)aString;
+ (NSString *)setterNameForKey:(NSString *)key;

+ (NSString *)descriptionWithObject:(id)anObject selector:(SEL)aSelector;
- (NSString *)description;

@end
