#import "common.h"
#import "CMMessageNode.h"
#import "CMNodeVisitor.h"

@implementation CMMessageNode

+ (id)nodeWithExpression:(id)anExpression
{
  return [[[self alloc] initWithExpression:anExpression] autorelease];
}

+ (id)nodeWithExpression:(id)anExpression message:(NSString *)aMessage
{
  return [[[self alloc] initWithExpression:anExpression
                        message:aMessage] autorelease];
}

+ (id)nodeWithExpression:(id)anExpression
                 message:(NSString *)aMessage
               arguments:(NSArray *)names
{
  return [[[self alloc] initWithExpression:anExpression
                        message:aMessage
                        arguments:names] autorelease];
}

+ (id)nodeWithMessage:(NSString *)aMessage
{
  return [[[self alloc] initWithMessage:aMessage] autorelease];
}

- (id)init
{
  [super init];
  args = [[NSMutableArray alloc] initWithCapacity:1];
  return self;
}

- (id)initWithExpression:(id)anExpression
{
  [self init];
  [self addNode:[anExpression retain]];
  return self;
}

- (id)initWithExpression:(id)anExpression
                 message:(NSString *)aMessage
{
  [self init];
  [self addNode:[anExpression retain]];
  message = [[NSString alloc] initWithString:aMessage];
  return self;
}

- (id)initWithExpression:(id)anExpression
                 message:(NSString *)aMessage
               arguments:(NSArray *)names
{
  [self init];
  [self addNode:[anExpression retain]];
  message = [[NSString alloc] initWithString:aMessage];
  args = [names retain];
  return self;
}

- (id)initWithMessage:(NSString *)aMessage
{
  [self init];
  message = [[NSMutableString alloc] initWithString:aMessage];
  return self;
}

- (void)dealloc
{
  // expr $B$O%+%C%H(B
  [expr release];
  [message release];
  [args release];
  [super dealloc];
}

- (void)insertStringToMessage:(NSString *)aString
{
  [message insertString:aString atIndex:0];
}

- (void)appendStringToMessage:(NSString *)aString
{
  [message appendString:aString];
}

- (void)addArgument:(id)anObject
{
  [args addObject:anObject];
}

- (BOOL)isSingleMessage
{
  return [nodes count] < 2 && [message rangeOfString:@":"].length == 0;
}

- (BOOL)isKeywordMessage
{
  return [message rangeOfString:@":"].length != 0;
}

- (NSString *)ownDescription
{
  return [NSString stringWithFormat:@"%@", message];
}

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitMessageNode");
  [aVisitor visitMessageNode:self];
  LOG(@"<== visitMessageNode");
}

- (id)expression { return [nodes objectAtIndex:0]; }
- (NSString *)message { return message; }

- (NSArray *)argumentNodes
{
  if ([self isSingleMessage])
    return [NSArray array];

  NSRange range;
  range.location = 1;
  range.length = [nodes count] - 1;
  LOG(@"nodes - %@", [nodes description]);
  return [nodes subarrayWithRange:range];
}

- (SEL)selector { return selector; }
- (void)setSelector:(SEL)aSelector { selector = aSelector; }

- (BOOL)isDefined
{
  return [[message componentsSeparatedByString:@":"] count] <= [nodes count];
}

@end
